"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getRemoteSyncedIntegrationsInfoByOutputId = void 0;
var _nodeFetch = _interopRequireDefault(require("node-fetch"));
var _common = require("../../../common");
var _services = require("../../services");
var _errors = require("../../errors");
var _fleet_synced_integrations = require("../../services/setup/fleet_synced_integrations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getRemoteSyncedIntegrationsInfoByOutputId = async (soClient, outputId) => {
  const logger = _services.appContextService.getLogger();
  if (!(0, _fleet_synced_integrations.canEnableSyncIntegrations)()) {
    return {
      integrations: []
    };
  }
  try {
    var _body, _body2, _body3, _body4, _body$integrations, _body5, _body6, _errorMessage, _body7;
    const output = await _services.outputService.get(soClient, outputId);
    if ((output === null || output === void 0 ? void 0 : output.type) !== 'remote_elasticsearch') {
      throw new _errors.FleetError(`Output ${outputId} is not a remote elasticsearch output`);
    }
    const {
      kibana_api_key: kibanaApiKey,
      kibana_url: kibanaUrl,
      sync_integrations: syncIntegrations
    } = output;
    if (!syncIntegrations) {
      throw new _errors.FleetError(`Synced integrations not enabled`);
    }
    if (!kibanaUrl || kibanaUrl === '') {
      throw new _errors.FleetNotFoundError(`Remote Kibana URL not set on the output.`);
    }
    if (!kibanaApiKey) {
      throw new _errors.FleetNotFoundError(`Remote Kibana API key for ${kibanaUrl} not found`);
    }
    const options = {
      headers: {
        'kbn-xsrf': 'true',
        'User-Agent': `Kibana/${_services.appContextService.getKibanaVersion()} node-fetch`,
        'Content-Type': 'application/json',
        'Elastic-Api-Version': _common.API_VERSIONS.public.v1,
        Authorization: `ApiKey ${kibanaApiKey}`
      },
      method: 'GET'
    };
    const url = `${kibanaUrl.replace(/\/$/, '')}/api/fleet/remote_synced_integrations/status`;
    logger.debug(`Fetching ${url}`);
    let body;
    let errorMessage;
    let res;
    try {
      res = await (0, _nodeFetch.default)(url, options);
      body = await res.json();
    } catch (error) {
      if (res) {
        errorMessage = `GET ${url} failed with status ${res.status}. ${error.message}`;
      } else {
        errorMessage = `GET ${url} failed with error: ${error.message}`;
      }
    }
    if ((_body = body) !== null && _body !== void 0 && _body.statusCode && (_body2 = body) !== null && _body2 !== void 0 && _body2.message) {
      errorMessage = `GET ${url} failed with status ${body.statusCode}. ${body.message}`;
    }
    if (((_body3 = body) === null || _body3 === void 0 ? void 0 : _body3.ok) === false && (_body4 = body) !== null && _body4 !== void 0 && _body4.message) {
      var _res;
      errorMessage = `GET ${url} failed with status ${(_res = res) === null || _res === void 0 ? void 0 : _res.status}: ${body.message}`;
    }
    return {
      integrations: (_body$integrations = (_body5 = body) === null || _body5 === void 0 ? void 0 : _body5.integrations) !== null && _body$integrations !== void 0 ? _body$integrations : [],
      custom_assets: (_body6 = body) === null || _body6 === void 0 ? void 0 : _body6.custom_assets,
      error: (_errorMessage = errorMessage) !== null && _errorMessage !== void 0 ? _errorMessage : (_body7 = body) === null || _body7 === void 0 ? void 0 : _body7.error
    };
  } catch (error) {
    if (error.isBoom && error.output.statusCode === 404) {
      return {
        integrations: [],
        error: `No output found with id ${outputId}`
      };
    } else if (error.type === 'system' && error.code === 'ECONNREFUSED') {
      throw new _errors.FleetError(`${error.message}${error.code}`);
    }
    logger.error(`${error}`);
    throw error;
  }
};
exports.getRemoteSyncedIntegrationsInfoByOutputId = getRemoteSyncedIntegrationsInfoByOutputId;