"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PutOutputRequestSchema = exports.PostOutputRequestSchema = exports.GetOutputsResponseSchema = exports.GetOutputsRequestSchema = exports.GetOneOutputRequestSchema = exports.GetLatestOutputHealthResponseSchema = exports.GetLatestOutputHealthRequestSchema = exports.GenerateLogstashApiKeyResponseSchema = exports.DeleteOutputResponseSchema = exports.DeleteOutputRequestSchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _models = require("../models");
var _utils = require("../../routes/schema/utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const GetOneOutputRequestSchema = exports.GetOneOutputRequestSchema = {
  params: _configSchema.schema.object({
    outputId: _configSchema.schema.string()
  })
};
const DeleteOutputRequestSchema = exports.DeleteOutputRequestSchema = {
  params: _configSchema.schema.object({
    outputId: _configSchema.schema.string()
  })
};
const DeleteOutputResponseSchema = exports.DeleteOutputResponseSchema = _configSchema.schema.object({
  id: _configSchema.schema.string()
});
const GenerateLogstashApiKeyResponseSchema = exports.GenerateLogstashApiKeyResponseSchema = _configSchema.schema.object({
  api_key: _configSchema.schema.string()
});
const GetOutputsRequestSchema = exports.GetOutputsRequestSchema = {};
const GetOutputsResponseSchema = exports.GetOutputsResponseSchema = (0, _utils.ListResponseSchema)(_models.OutputSchema.extendsDeep({
  unknowns: 'allow'
}));
const PostOutputRequestSchema = exports.PostOutputRequestSchema = {
  body: _models.OutputSchema
};
const PutOutputRequestSchema = exports.PutOutputRequestSchema = {
  params: _configSchema.schema.object({
    outputId: _configSchema.schema.string()
  }),
  body: _models.UpdateOutputSchema
};
const GetLatestOutputHealthRequestSchema = exports.GetLatestOutputHealthRequestSchema = {
  params: _configSchema.schema.object({
    outputId: _configSchema.schema.string()
  })
};
const GetLatestOutputHealthResponseSchema = exports.GetLatestOutputHealthResponseSchema = _configSchema.schema.object({
  state: _configSchema.schema.string({
    meta: {
      description: 'state of output, HEALTHY or DEGRADED'
    }
  }),
  message: _configSchema.schema.string({
    meta: {
      description: 'long message if unhealthy'
    }
  }),
  timestamp: _configSchema.schema.string({
    meta: {
      description: 'timestamp of reported state'
    }
  })
});