"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ReplicasField = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _shared_imports = require("../../../../../../shared_imports");
var _edit_policy_context = require("../../../edit_policy_context");
var _form = require("../../../form");
var _i18n_texts = require("../../../i18n_texts");
var _described_form_row = require("../../described_form_row");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/private/index_lifecycle_management/public/application/sections/edit_policy/components/phases/shared_fields/replicas_field.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ReplicasField = ({
  phase
}) => {
  var _policy$phases$phase, _policy$phases$phase$, _policy$phases$phase$2;
  const {
    policy
  } = (0, _edit_policy_context.useEditPolicyContext)();
  const initialValue = ((_policy$phases$phase = policy.phases[phase]) === null || _policy$phases$phase === void 0 ? void 0 : (_policy$phases$phase$ = _policy$phases$phase.actions) === null || _policy$phases$phase$ === void 0 ? void 0 : (_policy$phases$phase$2 = _policy$phases$phase$.allocate) === null || _policy$phases$phase$2 === void 0 ? void 0 : _policy$phases$phase$2.number_of_replicas) != null;
  return /*#__PURE__*/_react.default.createElement(_described_form_row.DescribedFormRow, {
    title: /*#__PURE__*/_react.default.createElement("h3", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 29,
        columnNumber: 14
      }
    }, _i18n_texts.i18nTexts.editPolicy.replicasLabel),
    description: _i18n.i18n.translate('xpack.indexLifecycleMgmt.editPolicy.numberOfReplicas.formRowDescription', {
      defaultMessage: 'Set the number of replicas. Remains the same as the previous phase by default.'
    }),
    switchProps: {
      'data-test-subj': `${phase}-setReplicasSwitch`,
      label: _i18n.i18n.translate('xpack.indexLifecycleMgmt.editPolicy.numberOfReplicas.switchLabel', {
        defaultMessage: 'Set replicas'
      }),
      initialValue
    },
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 28,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_form.UseField, {
    path: `phases.${phase}.actions.allocate.number_of_replicas`,
    component: _shared_imports.NumericField,
    componentProps: {
      fullWidth: false,
      euiFieldProps: {
        'data-test-subj': `${phase}-selectedReplicaCount`,
        min: 0
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 7
    }
  }));
};
exports.ReplicasField = ReplicasField;