"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getApi = void 0;
var _analytics = require("@kbn/analytics");
var _constants = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getApi = (useRequest, sendRequest, apiBasePath, trackMetric) => {
  function useLoadComponentTemplates() {
    return useRequest({
      path: `${apiBasePath}/component_templates`,
      method: 'get'
    });
  }
  function useLoadComponentTemplatesDatastream(name) {
    return useRequest({
      path: `${apiBasePath}/component_templates/${encodeURIComponent(name)}/datastreams`,
      method: 'get'
    });
  }
  function deleteComponentTemplates(names) {
    const result = sendRequest({
      path: `${apiBasePath}/component_templates/${names.map(name => encodeURIComponent(name)).join(',')}`,
      method: 'delete'
    });
    trackMetric(_analytics.METRIC_TYPE.COUNT, names.length > 1 ? _constants.UIM_COMPONENT_TEMPLATE_DELETE_MANY : _constants.UIM_COMPONENT_TEMPLATE_DELETE);
    return result;
  }
  function useLoadComponentTemplate(name) {
    return useRequest({
      path: `${apiBasePath}/component_templates/${encodeURIComponent(name)}`,
      method: 'get'
    });
  }
  async function createComponentTemplate(componentTemplate) {
    const result = await sendRequest({
      path: `${apiBasePath}/component_templates`,
      method: 'post',
      body: JSON.stringify(componentTemplate)
    });
    trackMetric(_analytics.METRIC_TYPE.COUNT, _constants.UIM_COMPONENT_TEMPLATE_CREATE);
    return result;
  }
  async function updateComponentTemplate(componentTemplate) {
    const {
      name
    } = componentTemplate;
    const result = await sendRequest({
      path: `${apiBasePath}/component_templates/${encodeURIComponent(name)}`,
      method: 'put',
      body: JSON.stringify(componentTemplate)
    });
    trackMetric(_analytics.METRIC_TYPE.COUNT, _constants.UIM_COMPONENT_TEMPLATE_UPDATE);
    return result;
  }
  async function getComponentTemplateDatastreams(name) {
    return sendRequest({
      path: `${apiBasePath}/component_templates/${encodeURIComponent(name)}/datastreams`,
      method: 'get'
    });
  }
  async function postDataStreamRollover(name) {
    return sendRequest({
      path: `${apiBasePath}/data_streams/${encodeURIComponent(name)}/rollover`,
      method: 'post'
    });
  }
  async function postDataStreamMappingsFromTemplate(name) {
    return sendRequest({
      path: `${apiBasePath}/data_streams/${encodeURIComponent(name)}/mappings_from_template`,
      method: 'post'
    });
  }
  function useLoadReferencedIndexTemplateMeta(name) {
    return useRequest({
      path: `${apiBasePath}/component_templates/${encodeURIComponent(name)}/referenced_index_template_meta`,
      method: 'get'
    });
  }
  async function getReferencedIndexTemplateMeta(name) {
    return sendRequest({
      path: `${apiBasePath}/component_templates/${encodeURIComponent(name)}/referenced_index_template_meta`,
      method: 'get'
    });
  }
  return {
    useLoadComponentTemplates,
    deleteComponentTemplates,
    useLoadComponentTemplate,
    createComponentTemplate,
    updateComponentTemplate,
    useLoadReferencedIndexTemplateMeta,
    useLoadComponentTemplatesDatastream,
    getReferencedIndexTemplateMeta,
    getComponentTemplateDatastreams,
    postDataStreamRollover,
    postDataStreamMappingsFromTemplate
  };
};
exports.getApi = getApi;