"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDetailsPageMappingsModelManagement = void 0;
var _trained_models = require("@kbn/ml-trained-models-utils/src/constants/trained_models");
var _react = require("react");
var _app_context = require("../application/app_context");
var _utils = require("../application/components/mappings_editor/lib/utils");
var _mappings_state_context = require("../application/components/mappings_editor/mappings_state_context");
var _types = require("../application/components/mappings_editor/types");
var _api = require("../application/services/api");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getCustomInferenceIdMap = (models, modelStatsById, downloadStates, elser, e5) => {
  var _modelStatsById$elser, _modelStatsById$e;
  const inferenceIdMap = models.reduce((inferenceMap, model) => {
    var _modelStatsById$model;
    const inferenceEntry = (0, _utils.isLocalModel)(model) ? {
      trainedModelId: model.service_settings.model_id,
      isDeployable: model.service === 'elasticsearch',
      isDeployed: ((_modelStatsById$model = modelStatsById[model.inference_id]) === null || _modelStatsById$model === void 0 ? void 0 : _modelStatsById$model.state) === 'started',
      isDownloading: Boolean(downloadStates[model.service_settings.model_id]),
      modelStats: modelStatsById[model.inference_id]
    } : {
      trainedModelId: '',
      isDeployable: false,
      isDeployed: false,
      isDownloading: false,
      modelStats: undefined
    };
    inferenceMap[model.inference_id] = inferenceEntry;
    return inferenceMap;
  }, {});
  const defaultInferenceIds = {
    [_types.DefaultInferenceModels.elser_model_2]: {
      trainedModelId: elser,
      isDeployable: true,
      isDeployed: ((_modelStatsById$elser = modelStatsById[elser]) === null || _modelStatsById$elser === void 0 ? void 0 : _modelStatsById$elser.state) === 'started',
      isDownloading: Boolean(downloadStates[elser]),
      modelStats: modelStatsById[elser]
    },
    [_types.DefaultInferenceModels.e5]: {
      trainedModelId: e5,
      isDeployable: true,
      isDeployed: ((_modelStatsById$e = modelStatsById[e5]) === null || _modelStatsById$e === void 0 ? void 0 : _modelStatsById$e.state) === 'started',
      isDownloading: Boolean(downloadStates[e5]),
      modelStats: modelStatsById[e5]
    }
  };
  return {
    ...defaultInferenceIds,
    ...inferenceIdMap
  };
};
async function getCuratedModelConfig(ml, model, version) {
  if (ml !== null && ml !== void 0 && ml.mlApi) {
    try {
      const result = await ml.mlApi.trainedModels.getCuratedModelConfig(model, version ? {
        version
      } : undefined);
      return result.model_id;
    } catch (e) {
      // pass through and return default models below
    }
  }
  return model === 'elser' ? _trained_models.LATEST_ELSER_MODEL_ID : _trained_models.LATEST_E5_MODEL_ID;
}
const useDetailsPageMappingsModelManagement = () => {
  const {
    plugins: {
      ml
    }
  } = (0, _app_context.useAppContext)();
  const dispatch = (0, _mappings_state_context.useDispatch)();
  const fetchInferenceToModelIdMap = (0, _react.useCallback)(async () => {
    var _ml$mlApi, _ml$mlApi2;
    const inferenceModels = await (0, _api.getInferenceEndpoints)();
    const trainedModelStats = await (ml === null || ml === void 0 ? void 0 : (_ml$mlApi = ml.mlApi) === null || _ml$mlApi === void 0 ? void 0 : _ml$mlApi.trainedModels.getTrainedModelStats());
    const downloadStates = await (ml === null || ml === void 0 ? void 0 : (_ml$mlApi2 = ml.mlApi) === null || _ml$mlApi2 === void 0 ? void 0 : _ml$mlApi2.trainedModels.getModelsDownloadStatus());
    const elser = await getCuratedModelConfig(ml, 'elser', _trained_models.LATEST_ELSER_VERSION);
    const e5 = await getCuratedModelConfig(ml, 'e5');
    const modelStatsById = (trainedModelStats === null || trainedModelStats === void 0 ? void 0 : trainedModelStats.trained_model_stats.reduce((acc, {
      model_id: modelId,
      deployment_stats: stats
    }) => {
      if (modelId && stats) {
        acc[stats.deployment_id] = stats;
      }
      return acc;
    }, {})) || {};
    const modelIdMap = getCustomInferenceIdMap(inferenceModels.data || [], modelStatsById, downloadStates || {}, elser, e5);
    dispatch({
      type: 'inferenceToModelIdMap.update',
      value: {
        inferenceToModelIdMap: modelIdMap
      }
    });
    return modelIdMap;
  }, [dispatch, ml]);
  return {
    fetchInferenceToModelIdMap
  };
};
exports.useDetailsPageMappingsModelManagement = useDetailsPageMappingsModelManagement;