"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.correctAll = void 0;
var _timespan_literals = require("./timespan_literals");
var _like = require("./like");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const correctAll = query => {
  const corrections = [];
  corrections.push(...(0, _timespan_literals.correctTimespanLiterals)(query));
  corrections.push(...(0, _like.correctLikeWildcards)(query));
  return corrections;
};
exports.correctAll = correctAll;