"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.combineSignal = combineSignal;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function combineSignal(left, right) {
  if (!right) {
    return left;
  }
  const controller = new AbortController();
  left === null || left === void 0 ? void 0 : left.addEventListener('abort', () => {
    controller.abort();
  });
  right === null || right === void 0 ? void 0 : right.addEventListener('abort', () => {
    controller.abort();
  });
  return controller.signal;
}