"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.serdeEventstreamIntoObservable = serdeEventstreamIntoObservable;
var _eventstreamSerdeNode = require("@smithy/eventstream-serde-node");
var _utilUtf = require("@smithy/util-utf8");
var _lodash = require("lodash");
var _rxjs = require("rxjs");
var _inferenceCommon = require("@kbn/inference-common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// AWS uses SerDe to send over serialized data, so we use their
// @smithy library to parse the stream data

function serdeEventstreamIntoObservable(readable) {
  return new _rxjs.Observable(subscriber => {
    const marshaller = new _eventstreamSerdeNode.EventStreamMarshaller({
      utf8Encoder: _utilUtf.toUtf8,
      utf8Decoder: _utilUtf.fromUtf8
    });
    async function processStream() {
      for await (const chunk of marshaller.deserialize(readable, _lodash.identity)) {
        if (chunk) {
          subscriber.next(chunk);
        }
      }
    }
    processStream().then(() => {
      subscriber.complete();
    }, error => {
      if (!(error instanceof Error)) {
        try {
          const exceptionType = error.headers[':exception-type'].value;
          const body = (0, _utilUtf.toUtf8)(error.body);
          let message = `Encountered error in Bedrock stream of type ${exceptionType}`;
          try {
            message += '\n' + JSON.parse(body).message;
          } catch (parseError) {
            // trap
          }
          error = (0, _inferenceCommon.createInferenceInternalError)(message);
        } catch (decodeError) {
          error = (0, _inferenceCommon.createInferenceInternalError)(decodeError.message);
        }
      }
      subscriber.error(error);
    });
  });
}