"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSystemMessageInstructions = getSystemMessageInstructions;
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getSystemMessageInstructions({
  tools
}) {
  const formattedTools = Object.entries(tools !== null && tools !== void 0 ? tools : {}).map(([name, tool]) => {
    return {
      name,
      ...tool
    };
  });
  if (formattedTools.length) {
    return `In this environment, you have access to a set of tools you can use to answer the user's question.

    DO NOT call a tool when it is not listed.
    ONLY define input that is defined in the tool properties.
    If a tool does not have properties, leave them out.

    It is EXTREMELY important that you generate valid JSON between the \`\`\`json and \`\`\` delimiters.

    IMPORTANT: make sure you start and end a tool call with the ${_constants.TOOL_USE_START} and ${_constants.TOOL_USE_END} markers, it MUST
    be included in the tool call.

    You can only call A SINGLE TOOL at a time. Do not call multiple tools, or multiple times the same tool, in the same
    response.

    You may call tools like this:

    ${_constants.TOOL_USE_START}
    \`\`\`json
    ${JSON.stringify({
      name: '[name of the tool]',
      input: {
        myProperty: 'myValue'
      }
    })}
    \`\`\`\
    ${_constants.TOOL_USE_END}

    For example, given the following tool:

    ${JSON.stringify({
      name: 'my_tool',
      description: 'A tool to call',
      schema: {
        type: 'object',
        properties: {
          myProperty: {
            type: 'string'
          }
        }
      }
    })}

    Use it the following way:

    ${_constants.TOOL_USE_START}
    \`\`\`json
    ${JSON.stringify({
      name: 'my_tool',
      input: {
        myProperty: 'myValue'
      }
    })}
    \`\`\`\
    ${_constants.TOOL_USE_END}

    Another example: given the following tool:

    ${JSON.stringify({
      name: 'my_tool_without_parameters',
      description: 'A tool to call without parameters'
    })}

    Use it the following way:

    ${_constants.TOOL_USE_START}
    \`\`\`json
    ${JSON.stringify({
      name: 'my_tool_without_parameters',
      input: {}
    })}
    \`\`\`\
    ${_constants.TOOL_USE_END}

    Here are the tools available:

    ${JSON.stringify(formattedTools.map(tool => ({
      name: tool.name,
      description: tool.description,
      ...(tool.schema ? {
        schema: tool.schema
      } : {})
    })))}

    `;
  }
  return `No tools are available anymore. DO NOT UNDER ANY CIRCUMSTANCES call any tool, regardless of whether it was previously called.`;
}