"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createChatModel = void 0;
var _inferenceLangchain = require("@kbn/inference-langchain");
var _get_connector_by_id = require("../util/get_connector_by_id");
var _create_client = require("./create_client");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createChatModel = async ({
  request,
  connectorId,
  actions,
  logger,
  chatModelOptions,
  anonymizationRulesPromise,
  regexWorker,
  esClient
}) => {
  const client = (0, _create_client.createClient)({
    actions,
    request,
    anonymizationRulesPromise,
    regexWorker,
    esClient,
    logger
  });
  const connector = await (0, _get_connector_by_id.getConnectorById)({
    connectorId,
    actions,
    request
  });
  return new _inferenceLangchain.InferenceChatModel({
    ...chatModelOptions,
    chatComplete: client.chatComplete,
    connector
  });
};
exports.createChatModel = createChatModel;