"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.toolsSchema = exports.toolChoiceSchema = exports.toolCallSchema = exports.promptBodySchema = exports.messageOptionsSchema = exports.chatCompleteBodySchema = exports.chatCompleteBaseSchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _inferenceCommon = require("@kbn/inference-common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const toolCallSchema = exports.toolCallSchema = _configSchema.schema.arrayOf(_configSchema.schema.object({
  toolCallId: _configSchema.schema.string(),
  function: _configSchema.schema.object({
    name: _configSchema.schema.string(),
    arguments: _configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.any())
  })
}));
const toolsSchema = exports.toolsSchema = _configSchema.schema.maybe(_configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.object({
  description: _configSchema.schema.string(),
  schema: _configSchema.schema.maybe(_configSchema.schema.object({
    type: _configSchema.schema.literal('object'),
    properties: _configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.any()),
    required: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string()))
  }))
})));
const toolChoiceSchema = exports.toolChoiceSchema = _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal(_inferenceCommon.ToolChoiceType.auto), _configSchema.schema.literal(_inferenceCommon.ToolChoiceType.none), _configSchema.schema.literal(_inferenceCommon.ToolChoiceType.required), _configSchema.schema.object({
  function: _configSchema.schema.string()
})]));
const messageOptionsSchema = exports.messageOptionsSchema = _configSchema.schema.object({
  tools: toolsSchema,
  toolChoice: toolChoiceSchema
});
const chatCompleteBaseSchema = exports.chatCompleteBaseSchema = _configSchema.schema.object({
  connectorId: _configSchema.schema.string(),
  maxRetries: _configSchema.schema.maybe(_configSchema.schema.number()),
  retryConfiguration: _configSchema.schema.maybe(_configSchema.schema.object({
    retryOn: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal('all'), _configSchema.schema.literal('auto')]))
  })),
  temperature: _configSchema.schema.maybe(_configSchema.schema.number()),
  modelName: _configSchema.schema.maybe(_configSchema.schema.string()),
  metadata: _configSchema.schema.maybe(_configSchema.schema.object({
    connectorTelemetry: _configSchema.schema.maybe(_configSchema.schema.object({
      pluginId: _configSchema.schema.maybe(_configSchema.schema.string()),
      aggregateBy: _configSchema.schema.maybe(_configSchema.schema.string())
    })),
    attributes: _configSchema.schema.maybe(_configSchema.schema.object({}, {
      unknowns: 'allow'
    }))
  })),
  functionCalling: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal('auto'), _configSchema.schema.literal('native'), _configSchema.schema.literal('simulated')]))
});
const messageSchema = _configSchema.schema.oneOf([_configSchema.schema.object({
  role: _configSchema.schema.literal(_inferenceCommon.MessageRole.Assistant),
  content: _configSchema.schema.oneOf([_configSchema.schema.string(), _configSchema.schema.literal(null)]),
  toolCalls: _configSchema.schema.maybe(toolCallSchema)
}), _configSchema.schema.object({
  role: _configSchema.schema.literal(_inferenceCommon.MessageRole.User),
  content: _configSchema.schema.string(),
  name: _configSchema.schema.maybe(_configSchema.schema.string())
}), _configSchema.schema.object({
  name: _configSchema.schema.string(),
  role: _configSchema.schema.literal(_inferenceCommon.MessageRole.Tool),
  toolCallId: _configSchema.schema.string(),
  response: _configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.any()),
  data: _configSchema.schema.maybe(_configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.any()))
})]);
const chatCompleteBodySchema = exports.chatCompleteBodySchema = _configSchema.schema.allOf([chatCompleteBaseSchema, messageOptionsSchema, _configSchema.schema.object({
  system: _configSchema.schema.maybe(_configSchema.schema.string()),
  messages: _configSchema.schema.arrayOf(messageSchema)
})]);
const promptSchema = _configSchema.schema.object({
  prompt: _configSchema.schema.object({
    name: _configSchema.schema.string(),
    description: _configSchema.schema.maybe(_configSchema.schema.string()),
    versions: _configSchema.schema.arrayOf(_configSchema.schema.allOf([messageOptionsSchema, _configSchema.schema.object({
      system: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.string(), _configSchema.schema.object({
        mustache: _configSchema.schema.object({
          template: _configSchema.schema.string()
        })
      })])),
      models: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.object({
        provider: _configSchema.schema.oneOf([_configSchema.schema.literal(_inferenceCommon.ModelProvider.Anthropic), _configSchema.schema.literal(_inferenceCommon.ModelProvider.Elastic), _configSchema.schema.literal(_inferenceCommon.ModelProvider.Google), _configSchema.schema.literal(_inferenceCommon.ModelProvider.OpenAI), _configSchema.schema.literal(_inferenceCommon.ModelProvider.Other)]),
        family: _configSchema.schema.oneOf([_configSchema.schema.literal(_inferenceCommon.ModelFamily.Claude), _configSchema.schema.literal(_inferenceCommon.ModelFamily.GPT), _configSchema.schema.literal(_inferenceCommon.ModelFamily.Gemini)]),
        id: _configSchema.schema.maybe(_configSchema.schema.string())
      }))),
      template: _configSchema.schema.oneOf([_configSchema.schema.object({
        static: _configSchema.schema.object({
          content: _configSchema.schema.string()
        })
      }), _configSchema.schema.object({
        mustache: _configSchema.schema.object({
          template: _configSchema.schema.string()
        })
      }), _configSchema.schema.object({
        chat: _configSchema.schema.object({
          messages: _configSchema.schema.arrayOf(_configSchema.schema.object({
            role: _configSchema.schema.oneOf([_configSchema.schema.literal(_inferenceCommon.MessageRole.User), _configSchema.schema.literal(_inferenceCommon.MessageRole.Assistant)]),
            content: _configSchema.schema.string()
          }))
        })
      })]),
      temperature: _configSchema.schema.maybe(_configSchema.schema.number())
    })]))
  }),
  input: _configSchema.schema.any(),
  prevMessages: _configSchema.schema.maybe(_configSchema.schema.arrayOf(messageSchema)),
  toolChoice: toolChoiceSchema
});
const promptBodySchema = exports.promptBodySchema = _configSchema.schema.allOf([chatCompleteBaseSchema, promptSchema]);