"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.logEntrylogRateAnomalyRT = exports.logEntrylogCategoryAnomalyRT = exports.logEntryAnomalyRT = exports.logEntryAnomalyDatasetsRT = exports.logEntryAnomalyCommonFieldsRT = exports.isCategoryAnomaly = exports.anomalyTypeRT = exports.anomaliesSortRT = void 0;
var rt = _interopRequireWildcard(require("io-ts"));
var _log_analysis_results = require("./log_analysis_results");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const anomalyTypeRT = exports.anomalyTypeRT = rt.keyof({
  logRate: null,
  logCategory: null
});
const logEntryAnomalyCommonFieldsRT = exports.logEntryAnomalyCommonFieldsRT = rt.type({
  id: rt.string,
  anomalyScore: rt.number,
  dataset: rt.string,
  typical: rt.number,
  actual: rt.number,
  type: anomalyTypeRT,
  duration: rt.number,
  startTime: rt.number,
  jobId: rt.string
});
const logEntrylogRateAnomalyRT = exports.logEntrylogRateAnomalyRT = logEntryAnomalyCommonFieldsRT;
const logEntrylogCategoryAnomalyRT = exports.logEntrylogCategoryAnomalyRT = rt.intersection([logEntryAnomalyCommonFieldsRT, rt.type({
  categoryId: rt.string,
  categoryRegex: rt.string,
  categoryTerms: rt.string
})]);
const logEntryAnomalyRT = exports.logEntryAnomalyRT = rt.union([logEntrylogRateAnomalyRT, logEntrylogCategoryAnomalyRT]);
const logEntryAnomalyDatasetsRT = exports.logEntryAnomalyDatasetsRT = rt.array(rt.string);
const isCategoryAnomaly = anomaly => {
  return anomaly.type === 'logCategory';
};
exports.isCategoryAnomaly = isCategoryAnomaly;
const sortOptionsRT = rt.keyof({
  anomalyScore: null,
  dataset: null,
  startTime: null
});
const anomaliesSortRT = exports.anomaliesSortRT = (0, _log_analysis_results.sortRT)(sortOptionsRT);