"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.buildMetadataFilter = buildMetadataFilter;
var _esQuery = require("@kbn/es-query");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function buildMetadataFilter({
  field,
  value,
  dataView,
  negate = false
}) {
  if (!dataView) {
    return null;
  }
  const indexField = dataView.getFieldByName(field);
  const areMultipleValues = Array.isArray(value) && value.length > 1;
  const filter = areMultipleValues ? (0, _esQuery.buildPhrasesFilter)(indexField, value, dataView) : (0, _esQuery.buildPhraseFilter)(indexField, Array.isArray(value) ? value[0] : value, dataView);
  filter.meta.type = areMultipleValues ? 'phrases' : 'phrase';
  filter.$state = {
    store: 'appState'
  };
  filter.meta.value = Array.isArray(value) ? !areMultipleValues ? `${value[0]}` : undefined : value;
  filter.meta.key = field;
  filter.meta.alias = null;
  filter.meta.negate = negate;
  filter.meta.disabled = false;
  return filter;
}