"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CategoryQualityWarnings = exports.CategoryQualityWarningReasonDescription = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _styled = _interopRequireDefault(require("@emotion/styled"));
var _log_analysis = require("../../../../common/log_analysis");
var _recreate_job_callout = require("./recreate_job_callout");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/infra/public/components/logging/log_analysis_job_status/quality_warning_notices.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const CategoryQualityWarnings = ({
  hasSetupCapabilities,
  onRecreateMlJob,
  qualityWarnings
}) => {
  const [detailAccordionId] = (0, _react.useState)((0, _eui.htmlIdGenerator)()());
  const categoryQualityWarningsByJob = (0, _lodash.groupBy)(qualityWarnings, 'jobId');
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, Object.entries(categoryQualityWarningsByJob).map(([jobId, qualityWarningsForJob]) => /*#__PURE__*/_react.default.createElement(_recreate_job_callout.RecreateJobCallout, {
    hasSetupCapabilities: hasSetupCapabilities,
    key: `quality-warnings-callout-${jobId}`,
    onRecreateMlJob: onRecreateMlJob,
    title: categoryQualityWarningCalloutTitle,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 40,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.logs.logEntryCategories.categoryQualityWarningCalloutMessage",
    defaultMessage: "While analyzing the log messages we've detected some problems which might indicate a reduced quality of the categorization results. Consider excluding the respective datasets from the analysis.",
    tagName: "p",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: detailAccordionId,
    buttonContent: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.infra.logs.logEntryCategories.categoryQualityWarningDetailsAccordionButtonLabel",
      defaultMessage: "Details",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 54,
        columnNumber: 15
      }
    }),
    paddingSize: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 13
    }
  }, qualityWarningsForJob.flatMap(qualityWarning => /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    key: `item-${(0, _log_analysis.getFriendlyNameForPartitionId)(qualityWarning.dataset)}`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
    "data-test-subj": `title-${qualityWarning.dataset}`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 19
    }
  }, (0, _log_analysis.getFriendlyNameForPartitionId)(qualityWarning.dataset)), qualityWarning.reasons.map(reason => /*#__PURE__*/_react.default.createElement(QualityWarningReasonDescription, {
    key: `description-${reason.type}-${qualityWarning.dataset}`,
    "data-test-subj": `description-${reason.type}-${qualityWarning.dataset}`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement(CategoryQualityWarningReasonDescription, {
    reason: reason,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 23
    }
  }))))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 11
    }
  }))));
};
exports.CategoryQualityWarnings = CategoryQualityWarnings;
const QualityWarningReasonDescription = (0, _styled.default)(_eui.EuiDescriptionListDescription)`
  display: list-item;
  list-style-type: disc;
  margin-left: ${props => props.theme.euiTheme.size.m};
`;
const categoryQualityWarningCalloutTitle = _i18n.i18n.translate('xpack.infra.logs.logEntryCategories.categoryQUalityWarningCalloutTitle', {
  defaultMessage: 'Quality warning'
});
const CategoryQualityWarningReasonDescription = ({
  reason
}) => {
  switch (reason.type) {
    case 'singleCategory':
      return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.infra.logs.logEntryCategories.singleCategoryWarningReasonDescription",
        defaultMessage: "The analysis couldn't extract more than a single category from the log messages.",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 105,
          columnNumber: 9
        }
      });
    case 'manyRareCategories':
      return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.infra.logs.logEntryCategories.manyRareCategoriesWarningReasonDescription",
        defaultMessage: "{rareCategoriesRatio, number, percent} of the categories only rarely have messages assigned to them.",
        values: {
          rareCategoriesRatio: reason.rareCategoriesRatio
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 112,
          columnNumber: 9
        }
      });
    case 'manyCategories':
      return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.infra.logs.logEntryCategories.manyCategoriesWarningReasonDescription",
        defaultMessage: "The ratio of categories per analyzed document is very high with {categoriesDocumentRatio, number }.",
        values: {
          categoriesDocumentRatio: reason.categoriesDocumentRatio.toFixed(2)
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 122,
          columnNumber: 9
        }
      });
    case 'noFrequentCategories':
      return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.infra.logs.logEntryCategories.noFrequentCategoryWarningReasonDescription",
        defaultMessage: "None of the extracted categories frequently have messages assigned to them.",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 132,
          columnNumber: 9
        }
      });
    case 'manyDeadCategories':
      return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.infra.logs.logEntryCategories.manyDeadCategoriesWarningReasonDescription",
        defaultMessage: "{deadCategoriesRatio, number, percent} of the categories won't have new messages assigned to them because they are overshadowed by less specific categories.",
        values: {
          deadCategoriesRatio: reason.deadCategoriesRatio
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 139,
          columnNumber: 9
        }
      });
  }
};
exports.CategoryQualityWarningReasonDescription = CategoryQualityWarningReasonDescription;