"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Chart = void 0;
var _react = _interopRequireDefault(require("react"));
var _useAsync = _interopRequireDefault(require("react-use/lib/useAsync"));
var _use_reload_request_time = require("../../../../../../hooks/use_reload_request_time");
var _constants = require("../../../../../../../common/constants");
var _constants2 = require("../../../../../../common/visualizations/constants");
var _lens = require("../../../../../../components/lens");
var _use_unified_search = require("../../../hooks/use_unified_search");
var _use_hosts_view = require("../../../hooks/use_hosts_view");
var _build = require("../../../../../../utils/filters/build");
var _use_hosts_table = require("../../../hooks/use_hosts_table");
var _use_after_loaded_state = require("../../../hooks/use_after_loaded_state");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/infra/public/pages/metrics/hosts/components/tabs/metrics/chart.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const Chart = ({
  id,
  dataView,
  ...chartProps
}) => {
  const {
    searchCriteria
  } = (0, _use_unified_search.useUnifiedSearchContext)();
  const {
    loading
  } = (0, _use_hosts_view.useHostsViewContext)();
  const {
    reloadRequestTime
  } = (0, _use_reload_request_time.useReloadRequestTimeContext)();
  const {
    currentPage
  } = (0, _use_hosts_table.useHostsTableContext)();
  const shouldUseSearchCriteria = currentPage.length === 0;

  // prevents searchCriteria state from reloading the chart
  // we want it to reload only once the table has finished loading.
  // attributes passed to useAfterLoadedState don't need to be memoized
  const {
    afterLoadedState
  } = (0, _use_after_loaded_state.useAfterLoadedState)(loading, {
    dateRange: searchCriteria.dateRange,
    query: shouldUseSearchCriteria ? searchCriteria.query : undefined,
    reloadRequestTime
  });
  const {
    value: filters = []
  } = (0, _useAsync.default)(async () => {
    var _searchCriteria$panel;
    if (!(dataView !== null && dataView !== void 0 && dataView.id)) {
      return [];
    }
    return shouldUseSearchCriteria ? [...searchCriteria.filters, ...((_searchCriteria$panel = searchCriteria.panelFilters) !== null && _searchCriteria$panel !== void 0 ? _searchCriteria$panel : [])] : [(0, _build.buildCombinedAssetFilter)({
      field: _constants.HOST_NAME_FIELD,
      values: currentPage.map(p => p.name),
      dataView
    })];
  }, [currentPage, dataView, searchCriteria.filters, searchCriteria.panelFilters, shouldUseSearchCriteria]);
  return /*#__PURE__*/_react.default.createElement(_lens.LensChart, {
    lensAttributes: chartProps,
    id: `hostsView-metricChart-${id}`,
    borderRadius: "m",
    dateRange: afterLoadedState.dateRange,
    height: _constants2.METRIC_CHART_HEIGHT,
    loading: loading,
    filters: filters,
    query: afterLoadedState.query,
    lastReloadRequestTime: afterLoadedState.reloadRequestTime,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 5
    }
  });
};
exports.Chart = Chart;