"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SteppedGradientLegend = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _styled = _interopRequireDefault(require("@emotion/styled"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/infra/public/pages/metrics/inventory_view/components/waffle/stepped_gradient_legend.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const SteppedGradientLegend = ({
  legend,
  bounds,
  formatter
}) => {
  return /*#__PURE__*/_react.default.createElement(LegendContainer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 25,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(TickLabel, {
    value: 1,
    bounds: bounds,
    formatter: formatter,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 26,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(GradientContainer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 27,
      columnNumber: 7
    }
  }, legend.rules.slice().reverse().map((rule, index) => /*#__PURE__*/_react.default.createElement(GradientStep, {
    key: `step-${index}-${rule.value}`,
    style: {
      backgroundColor: rule.color
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 32,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(TickLabel, {
    value: 0,
    bounds: bounds,
    formatter: formatter,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 38,
      columnNumber: 7
    }
  }));
};
exports.SteppedGradientLegend = SteppedGradientLegend;
const TickLabel = ({
  value,
  bounds,
  formatter
}) => {
  const normalizedValue = value === 0 ? bounds.min : bounds.max * value;
  const label = formatter(normalizedValue);
  return /*#__PURE__*/_react.default.createElement("div", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 7
    }
  }, label));
};
const LegendContainer = _styled.default.div`
  position: relative;
  display: flex;
  flex-direction: column;
  justify-content: center;
  align-items: center;
`;
const GradientContainer = _styled.default.div`
  height: 200px;
  width: 10px;
  display: flex;
  flex-direction: column;
  align-items: stretch;
`;
const GradientStep = _styled.default.div`
  flex: 1 1 auto;
  &:first-child {
    border-radius: ${props => props.theme.euiTheme.border.radius}
      ${props => props.theme.euiTheme.border.radius} 0 0;
  }
  &:last-child {
    border-radius: 0 0 ${props => props.theme.euiTheme.border.radius}
      ${props => props.theme.euiTheme.border.radius};
  }
`;