"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createFormatterForMetric = void 0;
var _numeral = _interopRequireDefault(require("@elastic/numeral"));
var _formatters = require("../../../../../../common/formatters");
var _types = require("../../../../../common/inventory/types");
var _metric_to_format = require("./metric_to_format");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createFormatterForMetric = metric => {
  if ((metric === null || metric === void 0 ? void 0 : metric.aggregation) === 'custom') {
    return input => (0, _numeral.default)(input).format('0.[0000]');
  }
  if (metric && metric.field) {
    const format = (0, _metric_to_format.metricToFormat)(metric);
    if (format === _types.InfraFormatterType.bits && metric.aggregation === 'rate') {
      return (0, _formatters.createFormatter)(_types.InfraFormatterType.bits, '{{value}}/s');
    }
    return (0, _formatters.createFormatter)(format);
  }
  return (0, _formatters.createFormatter)(_types.InfraFormatterType.number);
};
exports.createFormatterForMetric = createFormatterForMetric;