"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NotFoundPanel = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _utils = require("../../utils");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/ingest_pipelines/public/application/sections/pipelines_list/flyout_content/not_found_panel.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const NotFoundPanel = ({
  pipelineName,
  error,
  displayWarning,
  onCreatePipeline
}) => {
  const renderErrorCallOut = () => {
    const isCustom = (0, _utils.isIntegrationsPipeline)(pipelineName);
    if (displayWarning || error.statusCode === 404 && isCustom) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
        title: isCustom ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.ingestPipelines.list.missingCustomPipeline.title",
          defaultMessage: "Custom pipeline does not exist",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 43,
            columnNumber: 15
          }
        }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.ingestPipelines.list.missingPipeline.title",
          defaultMessage: "The pipeline {pipelineName} does not exist.",
          values: {
            pipelineName: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
              __self: void 0,
              __source: {
                fileName: _jsxFileName,
                lineNumber: 52,
                columnNumber: 33
              }
            }, pipelineName)
          },
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 48,
            columnNumber: 15
          }
        }),
        color: "warning",
        iconType: "warning",
        "data-test-subj": "missingCustomPipeline",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 40,
          columnNumber: 9
        }
      }, isCustom && /*#__PURE__*/_react.default.createElement("p", {
        "data-test-subj": "cause",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 62,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ingestPipelines.list.missingCustomPipeline.text",
        defaultMessage: "The pipeline {pipelineName} does not exist.",
        values: {
          pipelineName: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 67,
              columnNumber: 33
            }
          }, pipelineName)
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 63,
          columnNumber: 15
        }
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        color: "warning",
        onClick: onCreatePipeline,
        "data-test-subj": "createCustomPipeline",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 72,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ingestPipelines.list.missingCustomPipeline.button",
        defaultMessage: "Create pipeline",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 77,
          columnNumber: 13
        }
      })));
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ingestPipelines.list.loadingError",
        defaultMessage: "Error loading pipeline",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 88,
          columnNumber: 11
        }
      }),
      color: "danger",
      iconType: "warning",
      "data-test-subj": "pipelineError",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 86,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement("p", {
      "data-test-subj": "cause",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 97,
        columnNumber: 9
      }
    }, (0, _utils.getErrorText)(error)));
  };
  const pipelineErrorTitleId = (0, _eui.useGeneratedHtmlId)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Inner, {
    "data-test-subj": "pipelineErrorFlyout",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 5
    }
  }, pipelineName && /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    id: "notFoundFlyoutTitle",
    "data-test-subj": "title",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    id: pipelineErrorTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 11
    }
  }, pipelineName)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 7
    }
  }), renderErrorCallOut());
};
exports.NotFoundPanel = NotFoundPanel;