"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fetchComponentData = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * Options for {@link fetchComponentData}.
 */

/**
 * Response type for POST '/internal/inspect_component/inspect' route.
 */

/**
 * Fetch component data.
 * @async
 * @param {FetchComponentDataOptions} options
 * @param {HttpStart} options.httpService {@link HttpStart}
 * @param {string} options.fileName Full component path.
 * @returns {Promise<InspectComponentResponse | undefined>} Resolves with {@link InspectComponentResponse component data} or null if an error occurs.
 */
const fetchComponentData = async ({
  httpService,
  fileName
}) => {
  try {
    const response = await httpService.post('/internal/inspect_component/inspect', {
      body: JSON.stringify({
        path: fileName
      })
    });
    return response;
  } catch (e) {
    return null;
  }
};
exports.fetchComponentData = fetchComponentData;