"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SingleCharsField = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _useList = _interopRequireDefault(require("react-use/lib/useList"));
var _useUpdateEffect = _interopRequireDefault(require("react-use/lib/useUpdateEffect"));
var _i18n = require("@kbn/i18n");
var _uiTheme = require("@kbn/ui-theme");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/private/interactive_setup/public/single_chars_field.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const SingleCharsField = ({
  defaultValue,
  length,
  separator,
  pattern = /^[0-9]$/,
  onChange,
  isInvalid,
  autoFocus = false
}) => {
  // Strip any invalid characters from input or clipboard and restrict length.
  const sanitize = str => {
    return str.split('').filter(char => char.match(pattern)).join('').substr(0, length);
  };
  const inputRefs = (0, _react.useRef)([]);
  const [chars, {
    set,
    updateAt
  }] = (0, _useList.default)(sanitize(defaultValue).split(''));
  const focusField = i => {
    const input = inputRefs.current[i];
    if (input) {
      input.focus();
    }
  };

  // Trigger `onChange` callback when characters change
  (0, _useUpdateEffect.default)(() => {
    onChange(chars.join(''));
  }, [chars]);

  // Focus first field on initial render
  (0, _react.useEffect)(() => {
    if (autoFocus) {
      focusField(0);
    }
  }, [autoFocus]);
  const children = [];
  for (let i = 0; i < length; i++) {
    var _chars$i;
    if (separator && i !== 0 && i % separator === 0) {
      children.push(/*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        key: `${i}separator`,
        grow: false,
        css: {
          width: parseInt(_uiTheme.euiThemeVars.euiFormControlHeight, 10) / 8
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 73,
          columnNumber: 9
        }
      }));
    }
    children.push(/*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      key: i,
      grow: false,
      css: {
        width: _uiTheme.euiThemeVars.euiFormControlHeight
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 82,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
      inputRef: el => {
        inputRefs.current[i] = el;
      },
      value: (_chars$i = chars[i]) !== null && _chars$i !== void 0 ? _chars$i : '',
      onChange: event => {
        // Ensure event doesn't bubble up since we manage our own `onChange` event
        event.stopPropagation();
      },
      onInput: event => {
        // Ignore input if invalid character was entered (unless empty)
        if (event.currentTarget.value !== '' && sanitize(event.currentTarget.value) === '') {
          return event.preventDefault();
        }
        updateAt(i, event.currentTarget.value);
        // Do not focus the next field if value is empty (e.g. when hitting backspace)
        if (event.currentTarget.value) {
          focusField(i + 1);
        }
      },
      onKeyDown: event => {
        if (event.key === 'Backspace') {
          // Clear previous field if current field is already empty
          if (event.currentTarget.value === '') {
            updateAt(i - 1, event.currentTarget.value);
            focusField(i - 1);
          }
        } else if (event.key === 'ArrowLeft') {
          focusField(i - 1);
        } else if (event.key === 'ArrowRight') {
          focusField(i + 1);
        }
      },
      onPaste: event => {
        const text = sanitize(event.clipboardData.getData('text'));
        set(text.split(''));
        focusField(Math.min(text.length, length - 1));
        event.preventDefault();
      },
      onFocus: event => {
        const input = event.currentTarget;
        setTimeout(() => input.select(), 0);
      },
      maxLength: 1,
      isInvalid: isInvalid,
      css: {
        textAlign: 'center'
      },
      "aria-label": _i18n.i18n.translate('interactiveSetup.singleCharsField.digitLabel', {
        defaultMessage: 'Digit {index}',
        values: {
          index: i + 1
        }
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 83,
        columnNumber: 9
      }
    })));
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    alignItems: "center",
    justifyContent: "center",
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 5
    }
  }, children);
};
exports.SingleCharsField = SingleCharsField;