"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InterceptPrompter = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var Rx = _interopRequireWildcard(require("rxjs"));
var _apmRum = require("@elastic/apm-rum");
var _service = require("./service");
var _user_intercept_run_persistence_service = require("./service/user_intercept_run_persistence_service");
var _constants = require("../../common/constants");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class InterceptPrompter {
  constructor() {
    (0, _defineProperty2.default)(this, "userInterceptRunPersistenceService", new _user_intercept_run_persistence_service.UserInterceptRunPersistenceService());
    (0, _defineProperty2.default)(this, "interceptDialogService", new _service.InterceptDialogService());
    (0, _defineProperty2.default)(this, "queueIntercept", void 0);
    // observer for page visibility changes, shared across all intercepts
    (0, _defineProperty2.default)(this, "pageHidden$", void 0);
    // Defines safe timer bound at 24 days, javascript browser timers are not reliable for longer intervals
    // see https://developer.mozilla.org/en-US/docs/Web/API/Window/setTimeout#maximum_delay_value,
    // rxjs can do longer intervals, but we want to avoid the risk of running into issues with browser timers.
    (0, _defineProperty2.default)(this, "MAX_TIMER_INTERVAL", 0x7b98a000);
  }
  // 24 days in milliseconds

  setup({
    analytics,
    notifications
  }) {
    this.interceptDialogService.setup({
      analytics,
      notifications
    });
    return {};
  }
  start({
    http,
    ...dialogServiceDeps
  }) {
    const {
      getUserTriggerData$,
      updateUserTriggerData
    } = this.userInterceptRunPersistenceService.start(http);
    ({
      add: this.queueIntercept
    } = this.interceptDialogService.start({
      ...dialogServiceDeps,
      persistInterceptRunId: updateUserTriggerData,
      staticAssetsHelper: http.staticAssets
    }));
    this.pageHidden$ = Rx.fromEvent(document, 'visibilitychange').pipe(Rx.map(() => document.hidden), Rx.startWith(document.hidden));
    return {
      /**
       * Configures the intercept journey that will be shown to the user, and returns an observable
       * that manages displaying the intercept at the appropriate time based on the interval that's been pre-configured for the
       * trigger ID matching the ID of this particular journey being configured.
       */
      registerIntercept: this.registerIntercept.bind(this, http, getUserTriggerData$)
    };
  }
  registerIntercept(http, getUserTriggerData$, intercept) {
    let nextRunId;
    return Rx.from(http.post(_constants.TRIGGER_INFO_API_ROUTE, {
      body: JSON.stringify({
        triggerId: intercept.id
      })
    })).pipe(Rx.filter(response => !!response)).pipe(Rx.mergeMap(response => {
      // anchor for all calculations, this is the time when the trigger was registered
      const timePoint = Date.now();
      let diff = 0;

      // Calculate the number of runs since the trigger was registered
      const runs = Math.floor((diff = timePoint - Date.parse(response.registeredAt)) / response.triggerIntervalInMs);
      nextRunId = runs + 1;
      return this.pageHidden$.pipe(Rx.switchMap(isHidden => {
        if (isHidden) return Rx.EMPTY;
        return Rx.timer(
        // create a timer that will not exceed the max timer interval
        Math.min(nextRunId * response.triggerIntervalInMs - diff, this.MAX_TIMER_INTERVAL), Math.min(response.triggerIntervalInMs, this.MAX_TIMER_INTERVAL)).pipe(Rx.switchMap(timerIterationCount => {
          if (response.triggerIntervalInMs < this.MAX_TIMER_INTERVAL) {
            return getUserTriggerData$(intercept.id);
          } else {
            const timeElapsedSinceRegistration = diff + this.MAX_TIMER_INTERVAL * timerIterationCount;
            const timeTillTriggerEvent = nextRunId * response.triggerIntervalInMs - timeElapsedSinceRegistration;
            if (timeTillTriggerEvent <= this.MAX_TIMER_INTERVAL) {
              // trigger event would happen sometime within this current slice
              // set up a single use timer that will emit the trigger event
              return Rx.timer(timeTillTriggerEvent).pipe(Rx.switchMap(() => {
                return getUserTriggerData$(intercept.id);
              }));
            } else {
              // current timer slice requires no action
              return Rx.EMPTY;
            }
          }
        }), Rx.takeWhile(triggerData => {
          // Stop the timer if lastInteractedInterceptId is defined and matches nextRunId
          if (!response.recurrent && triggerData.lastInteractedInterceptId) {
            return false;
          }
          return true;
        }));
      }));
    })).pipe(Rx.tap(async triggerData => {
      if (nextRunId !== triggerData.lastInteractedInterceptId) {
        try {
          var _this$queueIntercept;
          const interceptConfig = await intercept.config();
          (_this$queueIntercept = this.queueIntercept) === null || _this$queueIntercept === void 0 ? void 0 : _this$queueIntercept.call(this, {
            id: intercept.id,
            runId: nextRunId,
            ...interceptConfig
          });
          nextRunId++;
        } catch (err) {
          _apmRum.apm.captureError(err, {
            labels: {
              interceptId: intercept.id
            }
          });
        }
      }
    }));
  }
}
exports.InterceptPrompter = InterceptPrompter;