"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.initializeInternalApi = initializeInternalApi;
var _rxjs = require("rxjs");
var _esqlTypes = require("@kbn/esql-types");
var _helper = require("../helper");
var _type_guards = require("../type_guards");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function initializeInternalApi(initialState, parentApi, titleManager, {
  visualizationMap
}) {
  const hasRenderCompleted$ = new _rxjs.BehaviorSubject(false);
  const expressionParams$ = new _rxjs.BehaviorSubject(null);
  const expressionAbortController$ = new _rxjs.BehaviorSubject(undefined);
  if ((0, _type_guards.apiHasAbortController)(parentApi)) {
    expressionAbortController$.next(parentApi.abortController);
  }
  const renderCount$ = new _rxjs.BehaviorSubject(0);
  const attributes$ = new _rxjs.BehaviorSubject(initialState.attributes || (0, _helper.createEmptyLensState)().attributes);
  const overrides$ = new _rxjs.BehaviorSubject(initialState.overrides);
  const disableTriggers$ = new _rxjs.BehaviorSubject(initialState.disableTriggers);
  const dataLoading$ = new _rxjs.BehaviorSubject(undefined);
  const dataViews$ = new _rxjs.BehaviorSubject(undefined);
  // This is an internal error state, not to be confused with the runtime error state thrown by the expression pipeline
  // In both cases a blocking error can happen, but for Lens validation errors we want to have full control over the UI
  // while for runtime errors the error will bubble up to the embeddable presentation layer
  const validationMessages$ = new _rxjs.BehaviorSubject([]);
  // This other set of messages is for non-blocking messages that can be displayed in the UI
  const messages$ = new _rxjs.BehaviorSubject([]);

  // This should settle the thing once and for all
  // the isNewPanel won't be serialized so it will be always false after the edit panel closes applying the changes
  const isNewlyCreated$ = new _rxjs.BehaviorSubject(initialState.isNewPanel || false);
  const blockingError$ = new _rxjs.BehaviorSubject(undefined);
  const visualizationContext$ = new _rxjs.BehaviorSubject({
    // doc can point to a different set of attributes for the visualization
    // i.e. when inline editing or applying a suggestion
    activeAttributes: initialState.attributes,
    mergedSearchContext: {},
    indexPatterns: {},
    indexPatternRefs: [],
    activeVisualizationState: undefined,
    activeDatasourceState: undefined,
    activeData: undefined
  });
  const esqlVariables$ = (0, _esqlTypes.apiPublishesESQLVariables)(parentApi) ? parentApi.esqlVariables$ : new _rxjs.BehaviorSubject([]);

  // No need to expose anything at public API right now, that would happen later on
  // where each initializer will pick what it needs and publish it
  return {
    attributes$,
    overrides$,
    disableTriggers$,
    esqlVariables$,
    dataLoading$,
    hasRenderCompleted$,
    expressionParams$,
    expressionAbortController$,
    renderCount$,
    isNewlyCreated$,
    dataViews$,
    blockingError$,
    messages$,
    validationMessages$,
    dispatchError: () => {
      hasRenderCompleted$.next(true);
      renderCount$.next(renderCount$.getValue() + 1);
    },
    dispatchRenderStart: () => hasRenderCompleted$.next(false),
    dispatchRenderComplete: () => {
      renderCount$.next(renderCount$.getValue() + 1);
      hasRenderCompleted$.next(true);
    },
    updateExpressionParams: newParams => expressionParams$.next(newParams),
    updateDataLoading: newDataLoading => dataLoading$.next(newDataLoading),
    updateOverrides: overrides => overrides$.next(overrides),
    updateAttributes: attributes => attributes$.next(attributes),
    updateAbortController: abortController => expressionAbortController$.next(abortController),
    updateDisabledTriggers: disableTriggers => disableTriggers$.next(disableTriggers),
    updateDataViews: dataViews => dataViews$.next(dataViews),
    updateMessages: newMessages => messages$.next(newMessages),
    updateValidationMessages: newMessages => validationMessages$.next(newMessages),
    resetAllMessages: () => {
      messages$.next([]);
      validationMessages$.next([]);
    },
    updateBlockingError: blockingError => blockingError$.next(blockingError),
    setAsCreated: () => isNewlyCreated$.next(false),
    getDisplayOptions: () => {
      var _visualizationMap$lat, _visualizationMap$lat2, _visualizationMap$lat3, _titleManager$api$hid;
      const latestAttributes = attributes$.getValue();
      if (!latestAttributes.visualizationType) {
        return {};
      }
      let displayOptions = (_visualizationMap$lat = (_visualizationMap$lat2 = visualizationMap[latestAttributes.visualizationType]) === null || _visualizationMap$lat2 === void 0 ? void 0 : (_visualizationMap$lat3 = _visualizationMap$lat2.getDisplayOptions) === null || _visualizationMap$lat3 === void 0 ? void 0 : _visualizationMap$lat3.call(_visualizationMap$lat2)) !== null && _visualizationMap$lat !== void 0 ? _visualizationMap$lat : {};
      if ((0, _type_guards.apiHasLensComponentProps)(parentApi) && parentApi.noPadding != null) {
        displayOptions = {
          ...displayOptions,
          noPadding: parentApi.noPadding
        };
      }
      if (displayOptions.noPanelTitle == null && (_titleManager$api$hid = titleManager.api.hideTitle$) !== null && _titleManager$api$hid !== void 0 && _titleManager$api$hid.getValue()) {
        displayOptions = {
          ...displayOptions,
          noPanelTitle: true
        };
      }
      return displayOptions;
    },
    getVisualizationContext: () => visualizationContext$.getValue(),
    updateVisualizationContext: newVisualizationContext => {
      visualizationContext$.next({
        ...visualizationContext$.getValue(),
        ...newVisualizationContext
      });
    }
  };
}