"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.deleteListItem = void 0;
var _utils = require("../utils");
var _ = require(".");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const deleteListItem = async ({
  id,
  esClient,
  listItemIndex,
  refresh = false
}) => {
  const listItem = await (0, _.getListItem)({
    esClient,
    id,
    listItemIndex
  });
  if (listItem == null) {
    return null;
  } else {
    const response = await esClient.deleteByQuery({
      index: listItemIndex,
      query: {
        ids: {
          values: [id]
        }
      },
      refresh
    });
    if (response.deleted) {
      const checkIfListItemDeleted = async () => {
        const deletedListItem = await (0, _.getListItem)({
          esClient,
          id,
          listItemIndex
        });
        if (deletedListItem !== null) {
          throw Error('List item was deleted, but the change was not propagated in the expected time interval.');
        }
      };
      await (0, _utils.waitUntilDocumentIndexed)(checkIfListItemDeleted);
    } else {
      throw Error('Deletion of List Item [item_id] from [item_index] was not successful');
    }
  }
  return listItem;
};
exports.deleteListItem = deleteListItem;