"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.jsonFromBase64StringRT = exports.createErrorFromShardFailure = exports.createAsyncRequestRTs = void 0;
var rt = _interopRequireWildcard(require("io-ts"));
var _jsonStableStringify = _interopRequireDefault(require("json-stable-stringify"));
var _typed_json = require("../../common/typed_json");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const jsonFromBase64StringRT = exports.jsonFromBase64StringRT = new rt.Type('JSONFromBase64String', _typed_json.jsonValueRT.is, (value, context) => {
  try {
    return rt.success(JSON.parse(Buffer.from(value, 'base64').toString()));
  } catch (error) {
    return rt.failure(error, context);
  }
}, a => Buffer.from((0, _jsonStableStringify.default)(a)).toString('base64'));
const createAsyncRequestRTs = (stateCodec, paramsCodec) => {
  const asyncRecoveredRequestRT = rt.type({
    id: stateCodec,
    params: paramsCodec
  });
  const asyncInitialRequestRT = rt.type({
    id: rt.undefined,
    params: paramsCodec
  });
  const asyncRequestRT = rt.union([asyncRecoveredRequestRT, asyncInitialRequestRT]);
  return {
    asyncInitialRequestRT,
    asyncRecoveredRequestRT,
    asyncRequestRT
  };
};
exports.createAsyncRequestRTs = createAsyncRequestRTs;
const createErrorFromShardFailure = failure => {
  var _failure$index, _failure$node, _failure$shard, _failure$reason$reaso, _failure$reason;
  return {
    type: 'shardFailure',
    shardInfo: {
      index: (_failure$index = failure.index) !== null && _failure$index !== void 0 ? _failure$index : null,
      node: (_failure$node = failure.node) !== null && _failure$node !== void 0 ? _failure$node : null,
      shard: (_failure$shard = failure.shard) !== null && _failure$shard !== void 0 ? _failure$shard : null
    },
    message: (_failure$reason$reaso = (_failure$reason = failure.reason) === null || _failure$reason === void 0 ? void 0 : _failure$reason.reason) !== null && _failure$reason$reaso !== void 0 ? _failure$reason$reaso : null
  };
};
exports.createErrorFromShardFailure = createErrorFromShardFailure;