"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTransformOut = getTransformOut;
var _get_transform_in = require("./get_transform_in");
var _references = require("../../migrations/references");
var _constants = require("../../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getTransformOut(transformEnhancementsOut) {
  function transformOut(state, references) {
    const enhancementsState = state.enhancements ? transformEnhancementsOut(state.enhancements, references !== null && references !== void 0 ? references : []) : undefined;

    // by ref
    const savedObjectRef = (references !== null && references !== void 0 ? references : []).find(ref => _constants.MAP_SAVED_OBJECT_TYPE === ref.type && ref.name === _get_transform_in.MAP_SAVED_OBJECT_REF_NAME);
    if (savedObjectRef) {
      return {
        ...state,
        ...(enhancementsState ? {
          enhancements: enhancementsState
        } : {}),
        savedObjectId: savedObjectRef.id
      };
    }

    // by value
    if (state.attributes) {
      return {
        ...state,
        ...(enhancementsState ? {
          enhancements: enhancementsState
        } : {}),
        attributes: (0, _references.injectReferences)({
          attributes: state.attributes,
          references: references !== null && references !== void 0 ? references : []
        }).attributes
      };
    }
    return {
      ...state,
      ...(enhancementsState ? {
        enhancements: enhancementsState
      } : {})
    };
  }
  return transformOut;
}