"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EXCLUDE_CENTROID_FEATURES = void 0;
exports.getFillFilterExpression = getFillFilterExpression;
exports.getLabelFilterExpression = getLabelFilterExpression;
exports.getLineFilterExpression = getLineFilterExpression;
exports.getPointFilterExpression = getPointFilterExpression;
var _constants = require("../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EXCLUDE_CENTROID_FEATURES = exports.EXCLUDE_CENTROID_FEATURES = ['!=', ['get', _constants.KBN_IS_CENTROID_FEATURE], true];
function getFilterExpression(filters, joinFilter, timesliceMaskConfig) {
  const allFilters = [...filters];
  if (joinFilter) {
    allFilters.push(joinFilter);
  }
  if (timesliceMaskConfig) {
    allFilters.push(['has', timesliceMaskConfig.timesliceMaskField]);
    allFilters.push(['>=', ['get', timesliceMaskConfig.timesliceMaskField], timesliceMaskConfig.timeslice.from]);
    allFilters.push(['<', ['get', timesliceMaskConfig.timesliceMaskField], timesliceMaskConfig.timeslice.to]);
  }
  return ['all', ...allFilters];
}
function getFillFilterExpression(joinFilter, timesliceMaskConfig) {
  return getFilterExpression([
  // explicit "exclude centroid features" filter not needed. Label features are points and are filtered out by geometry narrowing
  ['any', ['==', ['geometry-type'], _constants.GEO_JSON_TYPE.POLYGON], ['==', ['geometry-type'], _constants.GEO_JSON_TYPE.MULTI_POLYGON]]], joinFilter, timesliceMaskConfig);
}
function getLineFilterExpression(joinFilter, timesliceMaskConfig) {
  return getFilterExpression([
  // explicit "exclude centroid features" filter not needed. Label features are points and are filtered out by geometry narrowing
  ['any', ['==', ['geometry-type'], _constants.GEO_JSON_TYPE.POLYGON], ['==', ['geometry-type'], _constants.GEO_JSON_TYPE.MULTI_POLYGON], ['==', ['geometry-type'], _constants.GEO_JSON_TYPE.LINE_STRING], ['==', ['geometry-type'], _constants.GEO_JSON_TYPE.MULTI_LINE_STRING]]], joinFilter, timesliceMaskConfig);
}
const IS_POINT_FEATURE = ['any', ['==', ['geometry-type'], _constants.GEO_JSON_TYPE.POINT], ['==', ['geometry-type'], _constants.GEO_JSON_TYPE.MULTI_POINT]];
function getPointFilterExpression(isSourceGeoJson, isESVectorTileSource, joinFilter, timesliceMaskConfig) {
  const filters = [];
  if (isSourceGeoJson) {
    filters.push(EXCLUDE_CENTROID_FEATURES);
  } else if (isESVectorTileSource) {
    filters.push(['!=', ['get', '_mvt_label_position'], true]);
  }
  filters.push(IS_POINT_FEATURE);
  return getFilterExpression(filters, joinFilter, timesliceMaskConfig);
}
function getLabelFilterExpression(isSourceGeoJson, isESVectorTileSource, joinFilter, timesliceMaskConfig) {
  const filters = [];
  if (isSourceGeoJson) {
    // Centroid feature added to GeoJSON feature collection for LINE_STRING, MULTI_LINE_STRING, POLYGON, MULTI_POLYGON, and GEOMETRY_COLLECTION geometries
    // For GeoJSON sources, show label for centroid features or point/multi-point features only.
    // no explicit isCentroidFeature filter is needed, centroids are points and are included in the geometry filter.
    filters.push(IS_POINT_FEATURE);
  } else if (isESVectorTileSource) {
    filters.push(['==', ['get', '_mvt_label_position'], true]);
  }
  return getFilterExpression(filters, joinFilter, timesliceMaskConfig);
}