"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isGaugeTimeSeriesMetric = exports.isCounterTimeSeriesMetric = exports.TIME_SERIES_METRIC_TYPES = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/**
 * All available types for time series metric fields
 */
let TIME_SERIES_METRIC_TYPES = exports.TIME_SERIES_METRIC_TYPES = /*#__PURE__*/function (TIME_SERIES_METRIC_TYPES) {
  TIME_SERIES_METRIC_TYPES["HISTOGRAM"] = "histogram";
  TIME_SERIES_METRIC_TYPES["COUNTER"] = "counter";
  TIME_SERIES_METRIC_TYPES["GAUGE"] = "gauge";
  TIME_SERIES_METRIC_TYPES["SUMMARY"] = "summary";
  return TIME_SERIES_METRIC_TYPES;
}({});
/**
 * Check if DataViewField is a 'counter' time series metric field
 * @param field optional DataViewField
 * @returns a boolean
 */
const isCounterTimeSeriesMetric = field => (field === null || field === void 0 ? void 0 : field.timeSeriesMetric) === TIME_SERIES_METRIC_TYPES.COUNTER;

/**
 * Check if DataViewField is a 'gauge' time series metric field
 * @param field optional DataViewField
 * @returns a boolean
 */
exports.isCounterTimeSeriesMetric = isCounterTimeSeriesMetric;
const isGaugeTimeSeriesMetric = field => (field === null || field === void 0 ? void 0 : field.timeSeriesMetric) === TIME_SERIES_METRIC_TYPES.GAUGE;
exports.isGaugeTimeSeriesMetric = isGaugeTimeSeriesMetric;