"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MlTooltipComponent = exports.FormattedTooltip = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _reactPopperTooltip = require("react-popper-tooltip");
var _eui = require("@elastic/eui");
var _chart_tooltip_service = require("./chart_tooltip_service");
var _chart_tooltip_styles = require("./chart_tooltip_styles");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/ml/public/application/components/chart_tooltip/chart_tooltip.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const renderHeader = (headerData, formatter) => {
  if (!headerData) {
    return null;
  }
  return formatter ? formatter(headerData) : headerData.label;
};

/**
 * Pure component for rendering the tooltip content with a custom layout across the ML plugin.
 */
const FormattedTooltip = ({
  tooltipData
}) => {
  const {
    mlChartTooltip,
    mlChartTooltipList,
    mlChartTooltipHeader,
    mlChartTooltipItem,
    mlChartTooltipLabel,
    mlChartTooltipValue
  } = (0, _chart_tooltip_styles.useChartTooltipStyles)();
  return /*#__PURE__*/_react.default.createElement("div", {
    css: mlChartTooltip,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 5
    }
  }, tooltipData.length > 0 && tooltipData[0].skipHeader === undefined && /*#__PURE__*/_react.default.createElement("div", {
    css: mlChartTooltipHeader,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 9
    }
  }, renderHeader(tooltipData[0])), tooltipData.length > 1 && /*#__PURE__*/_react.default.createElement("div", {
    css: mlChartTooltipList,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 9
    }
  }, tooltipData.slice(1).map(({
    label,
    value,
    color,
    isHighlighted,
    seriesIdentifier,
    valueAccessor
  }) => {
    const classes = (0, _classnames.default)({
      // eslint-disable-next-line @typescript-eslint/naming-convention
      echTooltip__rowHighlighted: isHighlighted
    });
    const renderValue = Array.isArray(value) ? value.map(v => /*#__PURE__*/_react.default.createElement("div", {
      key: v,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 57,
        columnNumber: 36
      }
    }, v)) : value;
    return /*#__PURE__*/_react.default.createElement("div", {
      key: `${seriesIdentifier.key}__${valueAccessor}`,
      css: mlChartTooltipItem,
      className: classes,
      style: {
        borderLeftColor: color
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 61,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 69,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      css: mlChartTooltipLabel,
      className: "eui-textBreakWord",
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 70,
        columnNumber: 21
      }
    }, label), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      css: mlChartTooltipValue,
      className: "eui-textBreakAll",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 77,
        columnNumber: 21
      }
    }, renderValue)));
  })));
};

/**
 * Tooltip component bundled with the {@link ChartTooltipService}
 */
exports.FormattedTooltip = FormattedTooltip;
const Tooltip = /*#__PURE__*/_react.default.memo(({
  service
}) => {
  const [tooltipData, setData] = (0, _react.useState)([]);
  const {
    getTooltipProps,
    setTooltipRef,
    setTriggerRef
  } = (0, _reactPopperTooltip.usePopperTooltip)({
    placement: 'top-start',
    trigger: null,
    delayHide: 1000
  }, {
    modifiers: [{
      name: 'preventOverflow',
      options: {
        rootBoundary: 'viewport'
      }
    }]
  });
  (0, _react.useEffect)(() => {
    const subscription = service.tooltipState$.subscribe(tooltipState => {
      if (setTriggerRef && typeof setTriggerRef === 'function') {
        // update trigger
        setTriggerRef(tooltipState.target);
      }
      setData(tooltipState.tooltipData);
    });
    return () => {
      subscription.unsubscribe();
    };
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  const isTooltipShown = tooltipData.length > 0;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isTooltipShown && /*#__PURE__*/_react.default.createElement("div", (0, _extends2.default)({
    ref: setTooltipRef
  }, getTooltipProps({
    className: 'tooltip-container'
  }), {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 133,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(FormattedTooltip, {
    tooltipData: tooltipData,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 134,
      columnNumber: 11
    }
  })));
});
const MlTooltipComponent = ({
  children
}) => {
  const service = (0, _react.useMemo)(() => new _chart_tooltip_service.ChartTooltipService(), []);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(Tooltip, {
    service: service,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 150,
      columnNumber: 7
    }
  }), children(service));
};
exports.MlTooltipComponent = MlTooltipComponent;