"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useNavigateToPath = void 0;
var _react = require("react");
var _reactRouterDom = require("react-router-dom");
var _app = require("../../../../common/constants/app");
var _kibana_context = require("./kibana_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useNavigateToPath = () => {
  const {
    services: {
      application: {
        getUrlForApp,
        navigateToUrl
      }
    }
  } = (0, _kibana_context.useMlKibana)();
  const location = (0, _reactRouterDom.useLocation)();
  return (0, _react.useCallback)(async (path, preserveSearch = false) => {
    if (path === undefined) return;
    const modifiedPath = `${path}${preserveSearch === true ? location.search : ''}`;
    /**
     * Handle urls generated by MlUrlGenerator where '/app/ml' is automatically prepended
     */
    const url = modifiedPath.includes(_app.ML_APP_ROUTE) || modifiedPath.includes(_app.ML_MANAGEMENT_APP_ROUTE) ? modifiedPath : getUrlForApp(_app.PLUGIN_ID, {
      path: modifiedPath
    });
    await navigateToUrl(url);
  },
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [location]);
};
exports.useNavigateToPath = useNavigateToPath;