"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useStartAction = void 0;
var _react = _interopRequireWildcard(require("react"));
var _common = require("../analytics_list/common");
var _analytics_service = require("../../services/analytics_service");
var _start_action_name = require("./start_action_name");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/ml/public/application/data_frame_analytics/pages/analytics_management/components/action_start/use_start_action.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const useStartAction = canStartStopDataFrameAnalytics => {
  const [isModalVisible, setModalVisible] = (0, _react.useState)(false);
  const [item, setItem] = (0, _react.useState)();
  const startAnalytics = (0, _analytics_service.useStartAnalytics)();
  const closeModal = () => setModalVisible(false);
  const startAndCloseModal = () => {
    if (item !== undefined) {
      setModalVisible(false);
      startAnalytics(item);
    }
  };
  const openModal = newItem => {
    setItem(newItem);
    setModalVisible(true);
  };
  const startButtonEnabled = i => {
    if (!(0, _common.isDataFrameAnalyticsRunning)(i.stats.state)) {
      // Disable start for analytics jobs which have completed.
      const completeAnalytics = (0, _common.isCompletedAnalyticsJob)(i.stats);
      return canStartStopDataFrameAnalytics && !completeAnalytics;
    }
    return canStartStopDataFrameAnalytics;
  };
  const action = (0, _react.useMemo)(() => ({
    name: i => /*#__PURE__*/_react.default.createElement(_start_action_name.StartActionName, {
      isDisabled: !startButtonEnabled(i),
      item: i,
      canStartStopDataFrameAnalytics: canStartStopDataFrameAnalytics,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 56,
        columnNumber: 9
      }
    }),
    available: i => !(0, _common.isDataFrameAnalyticsRunning)(i.stats.state) && !(0, _common.isDataFrameAnalyticsFailed)(i.stats.state),
    enabled: startButtonEnabled,
    description: _start_action_name.startActionNameText,
    icon: 'play',
    type: 'icon',
    onClick: openModal,
    'data-test-subj': 'mlAnalyticsJobStartButton'
  }),
  // eslint-disable-next-line react-hooks/exhaustive-deps
  []);
  return {
    action,
    closeModal,
    isModalVisible,
    item,
    openModal,
    startAndCloseModal
  };
};
exports.useStartAction = useStartAction;