"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Controls = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _momentTimezone = _interopRequireDefault(require("moment-timezone"));
var _eui = require("@elastic/eui");
var _mlDateUtils = require("@kbn/ml-date-utils");
var _mlDataFrameAnalyticsUtils = require("@kbn/ml-data-frame-analytics-utils");
var _cytoscape = require("./cytoscape");
var _locator = require("../../../../../../common/constants/locator");
var _check_capabilities = require("../../../../capabilities/check_capabilities");
var _kibana = require("../../../../contexts/kibana");
var _ml = require("../../../../contexts/ml");
var _clone_action_name = require("../../analytics_management/components/action_clone/clone_action_name");
var _action_delete = require("../../analytics_management/components/action_delete");
var _delete_space_aware_item_check_modal = require("../../../../components/delete_space_aware_item_check_modal");
var _index_service = require("../../../../util/index_service");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/ml/public/application/data_frame_analytics/pages/job_map/components/controls.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function getListItemsFactory(showLicenseInfo) {
  return details => {
    if (showLicenseInfo === false) {
      delete details.license_level;
    }
    return Object.entries(details).map(([key, value]) => {
      let description;
      if (key === 'create_time') {
        description = (0, _mlDateUtils.formatHumanReadableDateTimeSeconds)((0, _momentTimezone.default)(value).unix() * 1000);
      } else {
        description = typeof value === 'object' ? /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
          language: "json",
          fontSize: "s",
          paddingSize: "s",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 73,
            columnNumber: 13
          }
        }, JSON.stringify(value, null, 2)) : value;
      }
      return {
        title: key,
        description
      };
    });
  };
}
const Controls = exports.Controls = /*#__PURE__*/_react.default.memo(({
  details,
  getNodeData,
  modelId,
  refreshJobsCallback,
  updateElements
}) => {
  var _capabilities$managem, _capabilities$managem2;
  const [showFlyout, setShowFlyout] = (0, _react.useState)(false);
  const [selectedNode, setSelectedNode] = (0, _react.useState)();
  const [isPopoverOpen, setPopover] = (0, _react.useState)(false);
  const [didUntag, setDidUntag] = (0, _react.useState)(false);
  const canCreateDataFrameAnalytics = (0, _check_capabilities.usePermissionCheck)('canCreateDataFrameAnalytics');
  const canDeleteDataFrameAnalytics = (0, _check_capabilities.usePermissionCheck)('canDeleteDataFrameAnalytics');
  const deleteAction = (0, _action_delete.useDeleteAction)(canDeleteDataFrameAnalytics);
  const {
    showLicenseInfo
  } = (0, _ml.useEnabledFeatures)();
  const getListItems = (0, _react.useMemo)(() => getListItemsFactory(showLicenseInfo), [showLicenseInfo]);
  const {
    closeDeleteJobCheckModal,
    deleteItem,
    deleteTargetIndex,
    isModalVisible,
    isDeleteJobCheckModalVisible,
    item,
    jobType,
    openModal,
    openDeleteJobCheckModal
  } = deleteAction;
  const {
    services: {
      share,
      application: {
        navigateToUrl,
        capabilities
      }
    }
  } = (0, _kibana.useMlKibana)();
  const {
    getDataViewIdFromName
  } = (0, _index_service.useMlIndexUtils)();
  const hasIngestPipelinesCapabilities = ((_capabilities$managem = capabilities.management) === null || _capabilities$managem === void 0 ? void 0 : (_capabilities$managem2 = _capabilities$managem.ingest) === null || _capabilities$managem2 === void 0 ? void 0 : _capabilities$managem2.ingest_pipelines) === true;
  const {
    toasts
  } = (0, _kibana.useNotifications)();
  const mlLocator = (0, _kibana.useMlLocator)();
  const navigateToPath = (0, _kibana.useNavigateToPath)();
  const navigateToWizardWithClonedJob = (0, _clone_action_name.useNavigateToWizardWithClonedJob)();
  const cy = (0, _react.useContext)(_cytoscape.CytoscapeContext);
  const deselect = (0, _react.useCallback)(() => {
    if (cy) {
      cy.elements().unselect();
    }
    setShowFlyout(false);
    setSelectedNode(undefined);
  }, [cy, setSelectedNode]);
  const nodeId = selectedNode === null || selectedNode === void 0 ? void 0 : selectedNode.data('id');
  const nodeLabel = selectedNode === null || selectedNode === void 0 ? void 0 : selectedNode.data('label');
  const nodeType = selectedNode === null || selectedNode === void 0 ? void 0 : selectedNode.data('type');
  const onCreateJobClick = (0, _react.useCallback)(async () => {
    const dataViewId = await getDataViewIdFromName(nodeLabel);
    if (dataViewId !== null) {
      const path = await mlLocator.getUrl({
        page: _locator.ML_PAGES.DATA_FRAME_ANALYTICS_CREATE_JOB,
        pageState: {
          index: dataViewId
        }
      });
      await navigateToPath(path);
    } else {
      toasts.addDanger(_i18n.i18n.translate('xpack.ml.dataframe.analyticsMap.flyout.dataViewMissingMessage', {
        defaultMessage: 'To create a job from this index create a data view for {indexTitle}.',
        values: {
          indexTitle: nodeLabel
        }
      }));
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [nodeLabel]);
  const onManagePipeline = (0, _react.useCallback)(async () => {
    const ingestPipelineLocator = share.url.locators.get('INGEST_PIPELINES_APP_LOCATOR');
    if (ingestPipelineLocator && nodeLabel !== null) {
      const path = await ingestPipelineLocator.getUrl({
        page: 'pipeline_list'
      });

      // Passing pipelineId here because pipeline_list is not recognizing pipelineId params
      await navigateToUrl(`${path}/?pipeline=${nodeLabel}`);
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [share.url.locators, nodeLabel]);
  const onAnalyzeDataDrift = (0, _react.useCallback)(async () => {
    closePopover();
    const path = await mlLocator.getUrl({
      page: _locator.ML_PAGES.DATA_DRIFT_CUSTOM,
      pageState: {
        comparison: nodeLabel
      }
    });
    await navigateToPath(path);
  }, [nodeLabel, navigateToPath, mlLocator]);
  const onCloneJobClick = (0, _react.useCallback)(async () => {
    var _details$nodeId;
    navigateToWizardWithClonedJob({
      config: details[nodeId],
      stats: (_details$nodeId = details[nodeId]) === null || _details$nodeId === void 0 ? void 0 : _details$nodeId.stats
    });
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [nodeId]);
  const onActionsButtonClick = () => {
    setPopover(!isPopoverOpen);
  };
  const closePopover = () => {
    setPopover(false);
  };

  // Set up Cytoscape event handlers
  (0, _react.useEffect)(() => {
    const selectHandler = event => {
      const targetNode = event.target;
      if (targetNode._private.data.type === _mlDataFrameAnalyticsUtils.JOB_MAP_NODE_TYPES.ANALYTICS_JOB_MISSING) {
        toasts.addWarning(_i18n.i18n.translate('xpack.ml.dataframe.analyticsMap.flyout.jobMissingMessage', {
          defaultMessage: 'There is no data available for job {label}.',
          values: {
            label: targetNode._private.data.label
          }
        }));
        return;
      }
      setSelectedNode(targetNode);
      setShowFlyout(true);
    };
    if (cy) {
      cy.on('select', 'node', selectHandler);
      cy.on('unselect', 'node', deselect);
    }
    return () => {
      if (cy) {
        cy.removeListener('select', 'node', selectHandler);
        cy.removeListener('unselect', 'node', deselect);
      }
    };
  }, [cy, deselect, toasts]);
  (0, _react.useEffect)(function updateElementsOnClose() {
    if (isModalVisible === false && deleteItem === true || didUntag === true) {
      let destIndexNode;
      if (deleteTargetIndex === true || didUntag === true) {
        const jobDetails = details[nodeId];
        const destIndex = jobDetails.dest.index;
        destIndexNode = `${destIndex}-${_mlDataFrameAnalyticsUtils.JOB_MAP_NODE_TYPES.INDEX}`;
      }
      updateElements(nodeId, nodeLabel, destIndexNode);
      setShowFlyout(false);
    }
  },
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [isModalVisible, deleteItem, didUntag]);
  const flyoutTitleId = (0, _eui.useGeneratedHtmlId)();
  if (showFlyout === false) {
    return null;
  }
  const button = /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    size: "s",
    iconType: "arrowDown",
    iconSide: "right",
    onClick: onActionsButtonClick,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 253,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.dataframe.analyticsMap.flyout.nodeActionsButton",
    defaultMessage: "Node actions",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 254,
      columnNumber: 9
    }
  }));
  const items = [...(nodeType === _mlDataFrameAnalyticsUtils.JOB_MAP_NODE_TYPES.ANALYTICS ? [/*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    key: `${nodeId}-delete`,
    icon: "trash",
    disabled: !canDeleteDataFrameAnalytics,
    onClick: () => {
      var _details$nodeId2;
      openDeleteJobCheckModal({
        config: details[nodeId],
        stats: (_details$nodeId2 = details[nodeId]) === null || _details$nodeId2 === void 0 ? void 0 : _details$nodeId2.stats
      });
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 264,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.dataframe.analyticsMap.flyout.deleteJobButton",
    defaultMessage: "Delete job",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 272,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    key: `${nodeId}-clone`,
    icon: "copy",
    disabled: !canCreateDataFrameAnalytics,
    onClick: onCloneJobClick,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 277,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.dataframe.analyticsMap.flyout.cloneJobButton",
    defaultMessage: "Clone job",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 283,
      columnNumber: 15
    }
  }))] : []), ...(nodeType === _mlDataFrameAnalyticsUtils.JOB_MAP_NODE_TYPES.INDEX ? [/*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    disabled: !canCreateDataFrameAnalytics,
    key: `${nodeId}-drift-data`,
    icon: "visTagCloud",
    onClick: onAnalyzeDataDrift,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 292,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.dataframe.analyticsMap.flyout.analyzeDrift",
    defaultMessage: "Analyze data drift",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 298,
      columnNumber: 15
    }
  }))] : []), ...(nodeType === _mlDataFrameAnalyticsUtils.JOB_MAP_NODE_TYPES.INDEX ? [/*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    disabled: !canCreateDataFrameAnalytics,
    key: `${nodeId}-create`,
    icon: "plusInCircle",
    onClick: onCreateJobClick,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 307,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.dataframe.analyticsMap.flyout.createJobButton",
    defaultMessage: "Create job from this index",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 313,
      columnNumber: 15
    }
  }))] : []), ...(modelId !== nodeLabel && (nodeType === _mlDataFrameAnalyticsUtils.JOB_MAP_NODE_TYPES.ANALYTICS || nodeType === _mlDataFrameAnalyticsUtils.JOB_MAP_NODE_TYPES.INDEX) ? [/*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    key: `${nodeId}-fetch-related`,
    icon: "branch",
    onClick: () => {
      getNodeData({
        id: nodeLabel,
        type: nodeType
      });
      if (cy) {
        cy.elements().unselect();
      }
      setShowFlyout(false);
      setPopover(false);
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 323,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.dataframe.analyticsMap.flyout.fetchRelatedNodesButton",
    defaultMessage: "Fetch related nodes",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 335,
      columnNumber: 15
    }
  }))] : []), ...(modelId !== nodeLabel && nodeType === _mlDataFrameAnalyticsUtils.JOB_MAP_NODE_TYPES.INGEST_PIPELINE && hasIngestPipelinesCapabilities ? [/*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    key: `${nodeId}-view-pipeline`,
    icon: "pipelineApp",
    onClick: onManagePipeline,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 346,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.dataframe.analyticsMap.flyout.viewIngestPipelineButton",
    defaultMessage: "View ingest pipeline",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 351,
      columnNumber: 15
    }
  }))] : [])];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPortal, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 361,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    "aria-labelledby": flyoutTitleId,
    ownFocus: true,
    size: "m",
    onClose: deselect,
    "data-test-subj": "mlAnalyticsJobMapFlyout",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 362,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 369,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 370,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 371,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 372,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    id: flyoutTitleId,
    "data-test-subj": "mlDataFrameAnalyticsNodeDetailsTitle",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 373,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.dataframe.analyticsMap.flyoutHeaderTitle",
    defaultMessage: "Details for {type} {id}",
    values: {
      id: nodeLabel,
      type: nodeType
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 374,
      columnNumber: 21
    }
  })))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 384,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 385,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 386,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    compressed: true,
    type: "column",
    listItems: nodeType === 'index-pattern' ? getListItems(details[nodeId][nodeLabel]) : getListItems(details[nodeId]),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 387,
      columnNumber: 17
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 399,
      columnNumber: 11
    }
  }, nodeType !== _mlDataFrameAnalyticsUtils.JOB_MAP_NODE_TYPES.TRAINED_MODEL && items.length > 0 ? /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: button,
    isOpen: isPopoverOpen,
    closePopover: closePopover,
    panelPaddingSize: "s",
    anchorPosition: "downLeft",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 401,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    items: items,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 408,
      columnNumber: 17
    }
  })) : null)), isDeleteJobCheckModalVisible && item && /*#__PURE__*/_react.default.createElement(_delete_space_aware_item_check_modal.DeleteSpaceAwareItemCheckModal, {
    mlSavedObjectType: jobType,
    ids: [item.config.id],
    onCloseCallback: closeDeleteJobCheckModal,
    canDeleteCallback: () => {
      // Item will always be set by the time we open the delete modal
      openModal(deleteAction.item);
      closeDeleteJobCheckModal();
    },
    refreshJobsCallback: refreshJobsCallback,
    setDidUntag: setDidUntag,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 414,
      columnNumber: 11
    }
  }), isModalVisible && /*#__PURE__*/_react.default.createElement(_action_delete.DeleteActionModal, (0, _extends2.default)({}, deleteAction, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 427,
      columnNumber: 28
    }
  })));
});