"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GeoJobCreator = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _job_creator = require("./job_creator");
var _default_configs = require("./util/default_configs");
var _new_job = require("../../../../../../common/constants/new_job");
var _general = require("./util/general");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class GeoJobCreator extends _job_creator.JobCreator {
  constructor(mlApi, newJobCapsService, indexPattern, savedSearch, query) {
    super(mlApi, newJobCapsService, indexPattern, savedSearch, query);
    (0, _defineProperty2.default)(this, "_geoField", null);
    (0, _defineProperty2.default)(this, "_geoAgg", null);
    // set partitionField as the default split field for geo jobs
    (0, _defineProperty2.default)(this, "_splitField", null);
    (0, _defineProperty2.default)(this, "_type", _new_job.JOB_TYPE.GEO);
    this.createdBy = _new_job.CREATED_BY_LABEL.GEO;
    this._wizardInitialized$.next(true);
  }
  setDefaultDetectorProperties(geo) {
    if (geo === null) {
      throw Error('lat_long aggregations missing');
    }
    this._geoAgg = geo;
  }
  get geoField() {
    return this._geoField;
  }
  get geoAgg() {
    return this._geoAgg;
  }
  setGeoField(field) {
    this._geoField = field;
    if (field === null) {
      this.removeSplitField();
      this._removeDetector(0);
      this._detectors.length = 0;
      this._fields.length = 0;
      return;
    }
    const agg = this._geoAgg;
    this.removeAllDetectors();
    const dtr = this._createDetector(agg, field);
    this._addDetector(dtr, agg, field);
  }

  // set the split field
  setSplitField(field) {
    this._splitField = field;
    if (this._splitField === null) {
      this.removeSplitField();
    } else {
      for (let i = 0; i < this._detectors.length; i++) {
        this._detectors[i].partition_field_name = this._splitField.id;
      }
    }
  }
  removeSplitField() {
    this._detectors.forEach(d => {
      delete d.partition_field_name;
    });
  }
  get splitField() {
    return this._splitField;
  }

  // create a new detector object, applying the overall split field
  _createDetector(agg, field) {
    const dtr = (0, _default_configs.createBasicDetector)(agg, field);
    if (this._splitField !== null) {
      dtr.partition_field_name = this._splitField.id;
    }
    return dtr;
  }
  get aggFieldPairs() {
    return this.detectors.map((d, i) => ({
      field: this._fields[i],
      agg: this._aggs[i]
    }));
  }
  cloneFromExistingJob(job, datafeed) {
    this._overrideConfigs(job, datafeed);
    this.createdBy = _new_job.CREATED_BY_LABEL.GEO;
    this._sparseData = (0, _general.isSparseDataJob)(job, datafeed);
    const detectors = (0, _general.getRichDetectors)(this.newJobCapsService, job, datafeed, this.additionalFields, false);
    this.removeSplitField();
    this.removeAllDetectors();
    this.removeAllDetectors();
    if (detectors.length) {
      this.setGeoField(detectors[0].field);
      if (detectors[0].partitionField !== null) {
        this.setSplitField(detectors[0].partitionField);
      }
    }
  }
}
exports.GeoJobCreator = GeoJobCreator;