"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WizardHorizontalSteps = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _step_types = require("../components/step_types");
var _new_job = require("../../../../../../common/constants/new_job");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/ml/public/application/jobs/new_job/pages/new_job/wizard_horizontal_steps.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const WizardHorizontalSteps = ({
  currentStep,
  highestStep,
  setCurrentStep,
  disableSteps,
  jobType
}) => {
  function jumpToStep(step) {
    if (step <= highestStep) {
      setCurrentStep(step);
    }
  }
  const stepsConfig = [{
    title: _i18n.i18n.translate('xpack.ml.newJob.wizard.step.timeRangeTitle', {
      defaultMessage: 'Time range'
    }),
    ...createStepProps(_step_types.WIZARD_STEPS.TIME_RANGE),
    'data-test-subj': 'mlJobWizardTimeRangeStep'
  }, {
    title: _i18n.i18n.translate('xpack.ml.newJob.wizard.step.pickFieldsTitle', {
      defaultMessage: 'Choose fields'
    }),
    ...createStepProps(_step_types.WIZARD_STEPS.PICK_FIELDS),
    'data-test-subj': 'mlJobWizardPickFieldsStep'
  }, {
    title: _i18n.i18n.translate('xpack.ml.newJob.wizard.step.jobDetailsTitle', {
      defaultMessage: 'Job details'
    }),
    ...createStepProps(_step_types.WIZARD_STEPS.JOB_DETAILS),
    'data-test-subj': 'mlJobWizardJobDetailsStep'
  }, {
    title: _i18n.i18n.translate('xpack.ml.newJob.wizard.step.validationTitle', {
      defaultMessage: 'Validation'
    }),
    ...createStepProps(_step_types.WIZARD_STEPS.VALIDATION),
    'data-test-subj': 'mlJobWizardValidationStep'
  }, {
    title: _i18n.i18n.translate('xpack.ml.newJob.wizard.step.summaryTitle', {
      defaultMessage: 'Summary'
    }),
    ...createStepProps(_step_types.WIZARD_STEPS.SUMMARY),
    'data-test-subj': 'mlJobWizardSummaryStep'
  }];
  if (jobType === _new_job.JOB_TYPE.ADVANCED) {
    stepsConfig.splice(0, 1, {
      title: _i18n.i18n.translate('xpack.ml.newJob.wizard.step.configureDatafeedTitle', {
        defaultMessage: 'Configure datafeed'
      }),
      ...createStepProps(_step_types.WIZARD_STEPS.ADVANCED_CONFIGURE_DATAFEED),
      'data-test-subj': 'mlJobWizardAdvancedStep'
    });
  }
  function createStepProps(step) {
    return {
      onClick: () => jumpToStep(step),
      status: currentStep === step ? 'selected' : currentStep > step ? 'complete' : 'incomplete',
      disabled: disableSteps || highestStep < step
    };
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiStepsHorizontal, {
    steps: stepsConfig,
    style: {
      backgroundColor: 'inherit'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 10
    }
  });
};
exports.WizardHorizontalSteps = WizardHorizontalSteps;