"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getEmbeddableTimeRange = void 0;
var _presentationPublishing = require("@kbn/presentation-publishing");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getEmbeddableTimeRange = embeddable => {
  var _embeddable$timeRange;
  let timeRange = (_embeddable$timeRange = embeddable.timeRange$) === null || _embeddable$timeRange === void 0 ? void 0 : _embeddable$timeRange.getValue();
  if (!timeRange && (0, _presentationPublishing.apiHasParentApi)(embeddable) && (0, _presentationPublishing.apiPublishesTimeRange)(embeddable.parentApi)) {
    timeRange = embeddable.parentApi.timeRange$.getValue();
  }
  return timeRange;
};
exports.getEmbeddableTimeRange = getEmbeddableTimeRange;