"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CREATE_LENS_VIS_TO_ML_AD_JOB_ACTION = void 0;
exports.createVisToADJobAction = createVisToADJobAction;
exports.isApiCompatible = void 0;
var _i18n = require("@kbn/i18n");
var _presentationPublishing = require("@kbn/presentation-publishing");
var _public = require("@kbn/lens-plugin/public");
var _public2 = require("@kbn/maps-plugin/public");
var _esQuery = require("@kbn/es-query");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const CREATE_LENS_VIS_TO_ML_AD_JOB_ACTION = exports.CREATE_LENS_VIS_TO_ML_AD_JOB_ACTION = 'createMLADJobAction';
const isApiCompatible = api => (0, _presentationPublishing.apiHasType)(api);
exports.isApiCompatible = isApiCompatible;
function createVisToADJobAction(getStartServices) {
  return {
    id: 'create-ml-ad-job-action',
    type: CREATE_LENS_VIS_TO_ML_AD_JOB_ACTION,
    order: 8,
    grouping: [{
      id: 'ml',
      order: 3
    }],
    getIconType(context) {
      return 'machineLearningApp';
    },
    getDisplayName: () => _i18n.i18n.translate('xpack.ml.actions.createADJobFromLens', {
      defaultMessage: 'Detect anomalies'
    }),
    async execute({
      embeddable
    }) {
      if (!embeddable) {
        throw new Error('Not possible to execute an action without the embeddable context');
      }
      try {
        if ((0, _public.isLensApi)(embeddable)) {
          const [{
            showLensVisToADJobFlyout
          }, [coreStart, {
            share,
            data,
            lens,
            dashboard
          }]] = await Promise.all([Promise.resolve().then(() => _interopRequireWildcard(require('../embeddables/job_creation/lens'))), getStartServices()]);
          if (lens === undefined) {
            return;
          }
          await showLensVisToADJobFlyout(embeddable, coreStart, share, data, dashboard, lens);
        } else if ((0, _public2.isMapApi)(embeddable)) {
          const [{
            showMapVisToADJobFlyout
          }, [coreStart, {
            share,
            data,
            dashboard
          }]] = await Promise.all([Promise.resolve().then(() => _interopRequireWildcard(require('../embeddables/job_creation/map'))), getStartServices()]);
          await showMapVisToADJobFlyout(embeddable, coreStart, share, data, dashboard);
        }
      } catch (e) {
        return Promise.reject();
      }
    },
    async isCompatible({
      embeddable
    }) {
      var _coreStart$applicatio, _coreStart$applicatio2;
      if (!isApiCompatible(embeddable) || !((0, _presentationPublishing.apiIsOfType)(embeddable, 'lens') || (0, _presentationPublishing.apiIsOfType)(embeddable, 'map'))) return false;
      const [coreStart, {
        lens
      }] = await getStartServices();
      if (!((_coreStart$applicatio = coreStart.application.capabilities.ml) !== null && _coreStart$applicatio !== void 0 && _coreStart$applicatio.canCreateJob) || !((_coreStart$applicatio2 = coreStart.application.capabilities.ml) !== null && _coreStart$applicatio2 !== void 0 && _coreStart$applicatio2.canStartStopDatafeed)) {
        return false;
      }
      try {
        if ((0, _public.isLensApi)(embeddable) && lens) {
          const vis = embeddable.getSavedVis();
          if (!vis || (0, _esQuery.isOfAggregateQueryType)(vis.state.query)) {
            return false;
          }
          const {
            getChartInfoFromVisualization,
            isCompatibleVisualizationType
          } = await Promise.resolve().then(() => _interopRequireWildcard(require('../application/jobs/new_job/job_from_lens')));
          const chartInfo = await getChartInfoFromVisualization(lens, vis);
          return isCompatibleVisualizationType(chartInfo);
        } else if ((0, _public2.isMapApi)(embeddable)) {
          const {
            isCompatibleMapVisualization
          } = await Promise.resolve().then(() => _interopRequireWildcard(require('../application/jobs/new_job/job_from_map')));
          return isCompatibleMapVisualization(embeddable);
        }
        return false;
      } catch (error) {
        // eslint-disable-next-line no-console
        console.error('Error attempting to check for ML job compatibility', error);
        return false;
      }
    }
  };
}