"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createMissingMonitoringDataAlertType = createMissingMonitoringDataAlertType;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _constants = require("../../../common/constants");
var _lazy_expression = require("./lazy_expression");
var _validation = require("./validation");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/private/monitoring/public/alerts/missing_monitoring_data_alert/missing_monitoring_data_alert.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function createMissingMonitoringDataAlertType() {
  return {
    id: _constants.RULE_MISSING_MONITORING_DATA,
    description: _constants.RULE_DETAILS[_constants.RULE_MISSING_MONITORING_DATA].description,
    iconClass: 'bell',
    documentationUrl(docLinks) {
      return `${docLinks.links.monitoring.alertsKibanaMissingData}`;
    },
    ruleParamsExpression: props => /*#__PURE__*/_react.default.createElement(_lazy_expression.LazyExpression, (0, _extends2.default)({}, props, {
      paramDetails: _constants.RULE_DETAILS[_constants.RULE_MISSING_MONITORING_DATA].paramDetails,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 28,
        columnNumber: 7
      }
    })),
    validate: _validation.validate,
    defaultActionMessage: '{{context.internalFullMessage}}',
    requiresAppContext: _constants.RULE_REQUIRES_APP_CONTEXT
  };
}