"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ElasticsearchTemplate = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/kibana-react-plugin/public");
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _page_template = require("../page_template");
var _constants = require("../../../../common/constants");
var _ingest_pipeline_modal = require("./ingest_pipeline_modal");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/private/monitoring/public/application/pages/elasticsearch/elasticsearch_template.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ElasticsearchTemplate = ({
  cluster,
  ...props
}) => {
  const {
    services
  } = (0, _public.useKibana)();
  const tabs = [{
    id: 'overview',
    label: _i18n.i18n.translate('xpack.monitoring.esNavigation.overviewLinkText', {
      defaultMessage: 'Overview'
    }),
    route: '/elasticsearch'
  }, {
    id: 'nodes',
    label: _i18n.i18n.translate('xpack.monitoring.esNavigation.nodesLinkText', {
      defaultMessage: 'Nodes'
    }),
    route: '/elasticsearch/nodes'
  }, {
    id: 'indices',
    label: _i18n.i18n.translate('xpack.monitoring.esNavigation.indicesLinkText', {
      defaultMessage: 'Indices'
    }),
    route: '/elasticsearch/indices'
  }];
  if (services.dashboard) {
    tabs.push({
      id: 'ingest_pipeines',
      label: _i18n.i18n.translate('xpack.monitoring.esNavigation.ingestPipelinesLinkText', {
        defaultMessage: 'Ingest Pipelines'
      }),
      prepend: /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
        content: _i18n.i18n.translate('xpack.monitoring.esNavigation.ingestPipelinesBetaTooltip', {
          defaultMessage: 'Ingest Pipeline monitoring is a beta feature'
        }),
        type: "beaker",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 58,
          columnNumber: 9
        }
      }),
      onClick: () => (0, _ingest_pipeline_modal.ingestPipelineTabOnClick)(services)
    });
  }
  if (cluster && mlIsSupported(cluster.license)) {
    tabs.push({
      id: 'ml',
      label: _i18n.i18n.translate('xpack.monitoring.esNavigation.jobsLinkText', {
        defaultMessage: 'Machine learning jobs'
      }),
      route: '/elasticsearch/ml_jobs'
    });
  }
  if (cluster !== null && cluster !== void 0 && cluster.isCcrEnabled) {
    tabs.push({
      id: 'ccr',
      label: _i18n.i18n.translate('xpack.monitoring.esNavigation.ccrLinkText', {
        defaultMessage: 'CCR'
      }),
      route: '/elasticsearch/ccr'
    });
  }
  return /*#__PURE__*/_react.default.createElement(_page_template.PageTemplate, (0, _extends2.default)({}, props, {
    tabs: tabs,
    product: "elasticsearch",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 10
    }
  }));
};
exports.ElasticsearchTemplate = ElasticsearchTemplate;
const mlIsSupported = license => (0, _lodash.includes)(_constants.ML_SUPPORTED_LICENSES, license.type);