"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ElasticsearchNodePage = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _lodash = require("lodash");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/kibana-react-plugin/public");
var _item_template = require("./item_template");
var _global_state_context = require("../../contexts/global_state_context");
var _elasticsearch = require("../../../components/elasticsearch");
var _setup_mode = require("../../../components/renderers/setup_mode");
var _setup_mode_context = require("../../../components/setup_mode/setup_mode_context");
var _use_local_storage = require("../../hooks/use_local_storage");
var _use_charts = require("../../hooks/use_charts");
var _nodes_by_indices = require("../../../components/elasticsearch/shard_allocation/transformers/nodes_by_indices");
var _labels = require("../../../components/elasticsearch/shard_allocation/lib/labels");
var _fetch_alerts = require("../../../lib/fetch_alerts");
var _constants = require("../../../../common/constants");
var _use_breadcrumbs = require("../../hooks/use_breadcrumbs");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/private/monitoring/public/application/pages/elasticsearch/node_page.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
// @ts-ignore
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ElasticsearchNodePage = ({
  clusters
}) => {
  var _data$nodeSummary2, _data$nodeSummary3, _data$nodeSummary4, _services$data2;
  const globalState = (0, _react.useContext)(_global_state_context.GlobalStateContext);
  const {
    generate: generateBreadcrumbs
  } = (0, _use_breadcrumbs.useBreadcrumbContainerContext)();
  const {
    zoomInfo,
    onBrush
  } = (0, _use_charts.useCharts)();
  const [showSystemIndices, setShowSystemIndices] = (0, _use_local_storage.useLocalStorage)('showSystemIndices', false);
  const [alerts, setAlerts] = (0, _react.useState)({});
  const {
    node
  } = (0, _reactRouterDom.useParams)();
  const {
    services
  } = (0, _public.useKibana)();
  const [data, setData] = (0, _react.useState)({});
  const clusterUuid = globalState.cluster_uuid;
  const cluster = (0, _lodash.find)(clusters, {
    cluster_uuid: clusterUuid
  });
  (0, _react.useEffect)(() => {
    if (cluster) {
      var _data$nodeSummary;
      generateBreadcrumbs(cluster.cluster_name, {
        inElasticsearch: true,
        name: 'nodes',
        instance: data === null || data === void 0 ? void 0 : (_data$nodeSummary = data.nodeSummary) === null || _data$nodeSummary === void 0 ? void 0 : _data$nodeSummary.name
      });
    }
  }, [cluster, generateBreadcrumbs, data === null || data === void 0 ? void 0 : (_data$nodeSummary2 = data.nodeSummary) === null || _data$nodeSummary2 === void 0 ? void 0 : _data$nodeSummary2.name]);
  const ccs = globalState.ccs;
  const [nodesByIndicesData, setNodesByIndicesData] = (0, _react.useState)([]);
  const title = _i18n.i18n.translate('xpack.monitoring.elasticsearch.node.overview.title', {
    defaultMessage: 'Elasticsearch - Nodes - {nodeName} - Overview',
    values: {
      nodeName: data === null || data === void 0 ? void 0 : (_data$nodeSummary3 = data.nodeSummary) === null || _data$nodeSummary3 === void 0 ? void 0 : _data$nodeSummary3.name
    }
  });
  const pageTitle = _i18n.i18n.translate('xpack.monitoring.elasticsearch.node.overview.pageTitle', {
    defaultMessage: 'Elasticsearch node: {node}',
    values: {
      node: data === null || data === void 0 ? void 0 : (_data$nodeSummary4 = data.nodeSummary) === null || _data$nodeSummary4 === void 0 ? void 0 : _data$nodeSummary4.name
    }
  });
  const getPageData = (0, _react.useCallback)(async () => {
    var _services$data, _services$http;
    const bounds = (_services$data = services.data) === null || _services$data === void 0 ? void 0 : _services$data.query.timefilter.timefilter.getBounds();
    const url = `../api/monitoring/v1/clusters/${clusterUuid}/elasticsearch/nodes/${node}`;
    if ((_services$http = services.http) !== null && _services$http !== void 0 && _services$http.fetch && clusterUuid) {
      var _services$http2;
      const response = await ((_services$http2 = services.http) === null || _services$http2 === void 0 ? void 0 : _services$http2.fetch(url, {
        method: 'POST',
        body: JSON.stringify({
          showSystemIndices,
          ccs,
          timeRange: {
            min: bounds.min.toISOString(),
            max: bounds.max.toISOString()
          },
          is_advanced: false
        })
      }));
      setData(response);
      const transformer = (0, _nodes_by_indices.nodesByIndices)();
      setNodesByIndicesData(transformer(response.shards, response.nodes));
      const alertsResponse = await (0, _fetch_alerts.fetchAlerts)({
        fetch: services.http.fetch,
        alertTypeIds: [_constants.RULE_CPU_USAGE, _constants.RULE_THREAD_POOL_SEARCH_REJECTIONS, _constants.RULE_THREAD_POOL_WRITE_REJECTIONS, _constants.RULE_MISSING_MONITORING_DATA, _constants.RULE_DISK_USAGE, _constants.RULE_MEMORY_USAGE],
        filters: [{
          nodeUuid: node
        }],
        clusterUuid,
        timeRange: {
          min: bounds.min.valueOf(),
          max: bounds.max.valueOf()
        }
      });
      setAlerts(alertsResponse);
    }
  }, [(_services$data2 = services.data) === null || _services$data2 === void 0 ? void 0 : _services$data2.query.timefilter.timefilter, services.http, clusterUuid, node, showSystemIndices, ccs]);
  const toggleShowSystemIndices = (0, _react.useCallback)(() => {
    setShowSystemIndices(!showSystemIndices);
  }, [showSystemIndices, setShowSystemIndices]);
  return /*#__PURE__*/_react.default.createElement(_item_template.ItemTemplate, {
    title: title,
    pageTitle: pageTitle,
    getPageData: getPageData,
    id: node,
    pageType: "nodes",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 135,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_setup_mode.SetupModeRenderer, {
    productName: _constants.ELASTICSEARCH_SYSTEM_ID,
    render: ({
      setupMode,
      flyoutComponent,
      bottomBarComponent
    }) => /*#__PURE__*/_react.default.createElement(_setup_mode_context.SetupModeContext.Provider, {
      value: {
        setupModeSupported: true
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 145,
        columnNumber: 11
      }
    }, flyoutComponent, /*#__PURE__*/_react.default.createElement(_elasticsearch.Node, (0, _extends2.default)({
      alerts: alerts,
      labels: _labels.labels.node,
      nodeId: node,
      clusterUuid: clusterUuid,
      onBrush: onBrush,
      zoomInfo: zoomInfo,
      toggleShowSystemIndices: toggleShowSystemIndices,
      showSystemIndices: showSystemIndices,
      nodesByIndices: nodesByIndicesData
    }, data, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 147,
        columnNumber: 13
      }
    })), bottomBarComponent),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 142,
      columnNumber: 7
    }
  }));
};
exports.ElasticsearchNodePage = ElasticsearchNodePage;