"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.formatLastSeenTimestamp = formatLastSeenTimestamp;
var _lodash = require("lodash");
var _moment = _interopRequireDefault(require("moment"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function formatLastSeenTimestamp(lastSeenTimestampRaw, dateFormat) {
  const lastSeenTimestamp = (0, _moment.default)(lastSeenTimestampRaw);
  const formattedTimestamp = lastSeenTimestamp.format(dateFormat);
  const relativeTime = (0, _lodash.capitalize)(lastSeenTimestamp.fromNow());
  const sixHoursAgo = (0, _moment.default)().subtract(6, 'hours');
  const shouldShowRelativeTime = !sixHoursAgo.isAfter(lastSeenTimestamp);
  return {
    shouldShowRelativeTime,
    formattedTimestamp,
    relativeTime
  };
}