"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useImportKnowledgeBaseEntries = useImportKnowledgeBaseEntries;
var _i18n = require("@kbn/i18n");
var _reactQuery = require("@kbn/react-query");
var _constants = require("../constants");
var _use_kibana = require("./use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useImportKnowledgeBaseEntries() {
  const {
    observabilityAIAssistant,
    notifications: {
      toasts
    }
  } = (0, _use_kibana.useKibana)().services;
  const queryClient = (0, _reactQuery.useQueryClient)();
  const observabilityAIAssistantApi = observabilityAIAssistant.service.callApi;
  return (0, _reactQuery.useMutation)([_constants.REACT_QUERY_KEYS.IMPORT_KB_ENTRIES], ({
    entries
  }) => {
    return observabilityAIAssistantApi('POST /internal/observability_ai_assistant/kb/entries/import', {
      signal: null,
      params: {
        body: {
          entries
        }
      }
    });
  }, {
    networkMode: 'always',
    onSuccess: (_data, {
      entries
    }) => {
      toasts.addSuccess(_i18n.i18n.translate('xpack.observabilityAiAssistantManagement.kb.importEntries.successNotification', {
        defaultMessage: 'Successfully imported {number} items',
        values: {
          number: entries.length
        }
      }));
      queryClient.invalidateQueries({
        queryKey: [_constants.REACT_QUERY_KEYS.GET_KB_ENTRIES],
        refetchType: 'all'
      });
    },
    onError: error => {
      var _error$body$message, _error$body;
      toasts.addError(new Error((_error$body$message = (_error$body = error.body) === null || _error$body === void 0 ? void 0 : _error$body.message) !== null && _error$body$message !== void 0 ? _error$body$message : error.message), {
        title: _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.kb.importEntries.errorNotification', {
          defaultMessage: 'Something went wrong while importing items'
        })
      });
    }
  });
}