"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useObservabilityAIAssistantChatService = useObservabilityAIAssistantChatService;
var _react = require("react");
var _observability_ai_assistant_chat_service_context = require("../context/observability_ai_assistant_chat_service_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useObservabilityAIAssistantChatService() {
  const service = (0, _react.useContext)(_observability_ai_assistant_chat_service_context.ObservabilityAIAssistantChatServiceContext);
  if (!service) {
    throw new Error('ObservabilityAIAssistantChatServiceContext not set. Did you wrap your component in `<ObservabilityAIAssistantChatServiceContext.Provider/>`?');
  }
  return useObservabilityAIAssistantChatServiceWithService(service);
}
function useObservabilityAIAssistantChatServiceWithService(service) {
  return service;
}