"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerServerRoutes = registerServerRoutes;
var _serverRouteRepository = require("@kbn/server-route-repository");
var _get_global_observability_ai_assistant_route_repository = require("./get_global_observability_ai_assistant_route_repository");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function registerServerRoutes({
  core,
  logger,
  dependencies,
  isDev
}) {
  (0, _serverRouteRepository.registerRoutes)({
    core,
    logger,
    repository: (0, _get_global_observability_ai_assistant_route_repository.getGlobalObservabilityAIAssistantServerRouteRepository)(),
    dependencies,
    runDevModeChecks: isDev
  });
}