"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Threshold = Threshold;
var _react = _interopRequireDefault(require("react"));
var _charts = require("@elastic/charts");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/observability/public/components/custom_threshold/components/threshold.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const NO_DATA_VALUE = _i18n.i18n.translate('xpack.observability.customThreshold.rule.noDataValue', {
  defaultMessage: 'No Data'
});
const THRESHOLD_NO_DATA_TITLE = _i18n.i18n.translate('xpack.observability.customThreshold.rule.thresholdNoDataTitle', {
  defaultMessage: 'Alert when'
});
function Threshold({
  chartProps: {
    theme,
    baseTheme
  },
  comparator,
  id,
  threshold,
  title,
  value,
  valueFormatter = d => String(d)
}) {
  const color = (0, _eui.useEuiBackgroundColor)('danger');
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "none",
    style: {
      height: '170px',
      overflow: 'hidden',
      position: 'relative',
      minWidth: '100%'
    },
    hasShadow: false,
    "data-test-subj": `threshold-${threshold.join('-')}-${value}`,
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_charts.Chart, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_charts.Settings, {
    theme: theme,
    baseTheme: baseTheme,
    locale: _i18n.i18n.getLocale(),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.Metric, {
    id: id,
    data: [[{
      title,
      extra: /*#__PURE__*/_react.default.createElement("span", {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 74,
          columnNumber: 19
        }
      }, value ? _i18n.i18n.translate('xpack.observability.customThreshold.rule.thresholdExtraTitle', {
        values: {
          comparator,
          threshold: threshold.map(t => valueFormatter(t)).join(' - ')
        },
        defaultMessage: `Alert when {comparator} {threshold}`
      }) : THRESHOLD_NO_DATA_TITLE),
      color,
      value: value !== null && value !== void 0 ? value : NO_DATA_VALUE,
      valueFormatter,
      icon: ({
        width,
        height,
        color: iconColor
      }) => /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        width: width,
        height: height,
        color: iconColor,
        type: "alert",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 93,
          columnNumber: 19
        }
      })
    }]],
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 9
    }
  })));
}