"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useTabId = void 0;
var _reactRouterDom = require("react-router-dom");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ALERT_DETAILS_TAB_URL_STORAGE_KEY = 'tabId';
const useTabId = () => {
  const {
    search
  } = (0, _reactRouterDom.useLocation)();
  const history = (0, _reactRouterDom.useHistory)();
  const getUrlTabId = () => {
    const searchParams = new URLSearchParams(search);
    return searchParams.get(ALERT_DETAILS_TAB_URL_STORAGE_KEY);
  };
  const setUrlTabId = (tabId, overrideSearchState, newSearchState) => {
    const searchParams = new URLSearchParams(overrideSearchState ? undefined : search);
    searchParams.set(ALERT_DETAILS_TAB_URL_STORAGE_KEY, tabId);
    if (newSearchState) {
      Object.entries(newSearchState).forEach(([key, value]) => {
        searchParams.set(key, value);
      });
    }
    history.replace({
      search: searchParams.toString()
    });
  };
  return {
    getUrlTabId,
    setUrlTabId
  };
};
exports.useTabId = useTabId;