"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.extractEsqlQueries = exports.esqlResponseToJson = void 0;
var _constants = require("@kbn/inference-plugin/common/tasks/nl_to_esql/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Converts an ES|QL /_query columnar response to a JSON representation
 */
const esqlResponseToJson = esql => {
  const results = [];
  const {
    columns,
    values
  } = esql;
  for (const item of values) {
    const entry = {};
    for (let i = 0; i < columns.length; i++) {
      entry[columns[i].name] = item[i];
    }
    results.push(entry);
  }
  return results;
};
exports.esqlResponseToJson = esqlResponseToJson;
const extractEsqlQueries = message => {
  return Array.from(message.matchAll(_constants.INLINE_ESQL_QUERY_REGEX)).map(([match, query]) => query);
};
exports.extractEsqlQueries = extractEsqlQueries;