"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useOnechatAgentById = void 0;
var _reactQuery = require("@kbn/react-query");
var _use_onechat_service = require("../use_onechat_service");
var _query_keys = require("../../query_keys");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useFetchAgentById = () => {
  const {
    agentService
  } = (0, _use_onechat_service.useOnechatServices)();
  return agentId => {
    if (!agentId) {
      return Promise.reject(new Error('Agent ID is required'));
    }
    return agentService.get(agentId);
  };
};
const useOnechatAgentById = agentId => {
  const fetchAgentById = useFetchAgentById();
  const {
    data,
    isLoading,
    error
  } = (0, _reactQuery.useQuery)({
    queryKey: _query_keys.queryKeys.agentProfiles.byId(agentId),
    queryFn: () => fetchAgentById(agentId),
    enabled: !!agentId
  });
  return {
    agent: data !== null && data !== void 0 ? data : null,
    isLoading,
    error
  };
};
exports.useOnechatAgentById = useOnechatAgentById;