"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.appPaths = void 0;
var _new_conversation = require("./new_conversation");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const appPaths = exports.appPaths = {
  root: '/',
  agents: {
    list: '/agents',
    new: '/agents/new',
    edit: ({
      agentId
    }) => {
      return `/agents/${agentId}`;
    }
  },
  chat: {
    new: `/conversations/${_new_conversation.newConversationId}`,
    newWithAgent: ({
      agentId
    }) => {
      return `/conversations/${_new_conversation.newConversationId}?agent_id=${agentId}`;
    },
    conversation: ({
      conversationId
    }) => {
      return `/conversations/${conversationId}`;
    }
  },
  tools: {
    list: '/tools',
    new: '/tools/new',
    details: ({
      toolId
    }) => `/tools/${toolId}`
  }
};