"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.newConversationId = exports.createNewConversation = void 0;
var _onechatCommon = require("@kbn/onechat-common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const newConversationId = exports.newConversationId = 'new';
const createNewConversation = () => {
  const now = new Date().toISOString();
  return {
    id: newConversationId,
    agent_id: _onechatCommon.oneChatDefaultAgentId,
    user: {
      id: '',
      username: ''
    },
    title: '',
    created_at: now,
    updated_at: now,
    rounds: []
  };
};
exports.createNewConversation = createNewConversation;