"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.executeAgent$ = void 0;
var _rxjs = require("rxjs");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const executeAgent$ = ({
  agentId,
  request,
  capabilities,
  agentService,
  conversation$,
  nextInput,
  abortSignal,
  defaultConnectorId
}) => {
  return conversation$.pipe((0, _rxjs.switchMap)(conversation => {
    return new _rxjs.Observable(observer => {
      agentService.execute({
        request,
        agentId,
        abortSignal,
        defaultConnectorId,
        agentParams: {
          nextInput,
          conversation: conversation.rounds,
          capabilities
        },
        onEvent: event => {
          observer.next(event);
        }
      }).then(() => {
        observer.complete();
      }, err => {
        observer.error(err);
      });
      return () => {};
    });
  }), (0, _rxjs.shareReplay)());
};
exports.executeAgent$ = executeAgent$;