"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.updateConversation = exports.toEs = exports.fromEsWithoutRounds = exports.fromEs = exports.createRequestToEs = void 0;
var _onechatCommon = require("@kbn/onechat-common");
var _onechatServer = require("@kbn/onechat-server");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const convertBaseFromEs = document => {
  if (!document._source) {
    throw new Error('No source found on get conversation response');
  }
  return {
    id: document._id,
    agent_id: document._source.agent_id,
    user: {
      id: document._source.user_id,
      username: document._source.user_name
    },
    title: document._source.title,
    created_at: document._source.created_at,
    updated_at: document._source.updated_at
  };
};
function serializeStepResults(rounds) {
  return rounds.map(round => ({
    ...round,
    steps: round.steps.map(step => {
      if (step.type === _onechatCommon.ConversationRoundStepType.toolCall) {
        return {
          ...step,
          results: JSON.stringify(step.results)
        };
      } else {
        return step;
      }
    })
  }));
}
function deserializeStepResults(rounds) {
  return rounds.map(round => ({
    ...round,
    steps: round.steps.map(step => {
      if (step.type === _onechatCommon.ConversationRoundStepType.toolCall) {
        var _step$progression;
        return {
          ...step,
          results: JSON.parse(step.results).map(result => {
            var _result$tool_result_i;
            return {
              ...result,
              tool_result_id: (_result$tool_result_i = result.tool_result_id) !== null && _result$tool_result_i !== void 0 ? _result$tool_result_i : (0, _onechatServer.getToolResultId)()
            };
          }),
          progression: (_step$progression = step.progression) !== null && _step$progression !== void 0 ? _step$progression : []
        };
      } else {
        return step;
      }
    })
  }));
}
const fromEs = document => {
  var _rounds;
  const base = convertBaseFromEs(document);

  // Migration: prefer legacy 'rounds' field, fallback to new 'conversation_rounds' field
  const rounds = (_rounds = document._source.rounds) !== null && _rounds !== void 0 ? _rounds : document._source.conversation_rounds;
  return {
    ...base,
    rounds: deserializeStepResults(rounds)
  };
};
exports.fromEs = fromEs;
const fromEsWithoutRounds = document => {
  return convertBaseFromEs(document);
};
exports.fromEsWithoutRounds = fromEsWithoutRounds;
const toEs = (conversation, space) => {
  return {
    agent_id: conversation.agent_id,
    user_id: conversation.user.id,
    user_name: conversation.user.username,
    space,
    title: conversation.title,
    created_at: conversation.created_at,
    updated_at: conversation.updated_at,
    // Explicitly omit rounds to ensure migration
    rounds: undefined,
    conversation_rounds: serializeStepResults(conversation.rounds)
  };
};
exports.toEs = toEs;
const updateConversation = ({
  conversation,
  update,
  space,
  updateDate
}) => {
  const updated = {
    ...conversation,
    ...update,
    space,
    updatedAt: updateDate.toISOString()
  };
  return updated;
};
exports.updateConversation = updateConversation;
const createRequestToEs = ({
  conversation,
  space,
  currentUser,
  creationDate
}) => {
  return {
    agent_id: conversation.agent_id,
    user_id: currentUser.id,
    user_name: currentUser.username,
    space,
    title: conversation.title,
    created_at: creationDate.toISOString(),
    updated_at: creationDate.toISOString(),
    conversation_rounds: serializeStepResults(conversation.rounds)
  };
};
exports.createRequestToEs = createRequestToEs;